package gov.va.med.domain.service.messaging.encode.hl7;

/**
 * CopayEncoder
 * This will encode and fill QBP_Q13 Copay query by parameter message structure segments.
 * This query will generate a tabular response.
 *
 * @author Tom Cornils
 * @version $Id: CopayEncoder.java,v 1.6 2005/08/12 18:14:29 tom Exp $
 * @since MHV 2.0 <br>Mar 18, 2005
 */
public class CopayEncoder extends HL7TabularEncoder {
	private static final String SUBJECT_AREA_NAME = "CopayBalance";
	private static final String[][] STRUCTURE = {
		{"Total Balance", "NM", "18"}
	};

	/*
	  message = "MSH|^~\&|EVET EVAULT|200HV^MHV.MED.DNS   ^DNS|EVET VISTA|442^CHY7D.DNS        .MED.DNS   ^DNS|2004012819021||QBP^Q13^QBP_Q13|65810481154|P|2.4|||AL|NE
	  	QPD|K13^CopayBalance^HL70471|123996-18|123996|CopayBalance|2000010100000|2004123124000
	  	PID|||1001023456^^^USVHA&&0363^NI^VA FACILITY ID&442&L~1477^^^USVHA&&0363^PI^VA FACILITY ID&442&L~123994321^^^USSSA&&0363^SS^VA FACILITY ID&200MH&L||TEST^HEATHER^J
	  	RDF|1|Total Balance^NM^18
	  	RCP|D";
	*/
	public String getSubjectArea() {
		return SUBJECT_AREA_NAME;
	}

	public String[][] getColumnStructure() {
		return STRUCTURE;
	}

	public int getQueryMode() {
		return QUERY_MODE_ASYNCHRONOUS;
	};

}
