package gov.va.med.domain.service.messaging.encode.hl7;

/**
 * AppointmentEncoder
 * This will encode and fill QBP_Q13 Appointments query by parameter message structure segments.
 * This query will generate a tabular response.
 *
 * @author Tom Cornils
 * @version $Id: AppointmentEncoder.java,v 1.6 2005/08/30 21:13:04 tom Exp $
 * @since MHV 2.0 <br>Mar 18, 2005
 */
public class AppointmentEncoder extends HL7TabularEncoder
{ 
    private static final String SUBJECT_AREA_NAME = "Appointments";
    private static final String[][] STRUCTURE = {
                             {"IEN", "NM", "30"},
                             {"Appointment Date/Time", "TS", "26"},
                             {"Clinic", "ST", "20"},
                             {"Status", "ST", "20"},
                             {"Appointment Type", "ST", "40"},
                             {"Lab", "TS", "26"},
                             {"Xray", "TS", "26"},
                             {"EKG", "TS", "26"},
                             {"Phone", "ST", "13"}
                            };                              

    /*
      message = "MSH|^~\&|EVET EVAULT|200HV^MHV.MED.DNS   ^DNS|EVET VISTA|442^CHY7D.DNS        .MED.DNS   ^DNS|2004012819021||QBP^Q13^QBP_Q13|65810481154|P|2.4|||AL|NE
      	QPD|K13^Appointments^HL70471|123996-2|123996|Appointments|2000010100000|2004123124000
      	PID|||1001023456^^^USVHA&&0363^NI^VA FACILITY ID&442&L~1477^^^USVHA&&0363^PI^VA FACILITY ID&442&L~123994321^^^USSSA&&0363^SS^VA FACILITY ID&200MH&L||TEST^HEATHER^J
      	RDF|8|IEN^NM^32~Appointment Date/Time^TS^26~Clinic^ST^20~Status^ST^10~Appointment Type^ST^60~Lab^TS^26~Xray^TS^26~EKG^TS^26
      	RCP|D";
    */
    public String getSubjectArea() {
        return  SUBJECT_AREA_NAME;
    }     

    public String[][] getColumnStructure()
    {
        return STRUCTURE;
    }
    
    public int getQueryMode() {
        return QUERY_MODE_ASYNCHRONOUS;
    };    
    
} 
