package gov.va.med.domain.service.messaging.encode.hl7;

/**
 * AppointmentEncoder
 * This will encode and fill QBP_Q11 Allergies query by parameter message segments.
 * This query will generate a pattern response.
 *
 * @author Tom Cornils
 * @version $Id: AllergyEncoder.java,v 1.2 2005/07/20 19:37:29 tom Exp $
 * @since MHV 2.0 <br>Mar 18, 2005
 */
public class AllergyEncoder extends QBP_Q11_Encoder
{ 
    private static final String SUBJECT_AREA_NAME = "Allergies";

    /*
      msg = "MSH|^~\&|EVET EVAULT|200HV^MHV.MED.DNS   ^DNS|EVET VISTA|442^CHY7D.DNS        .MED.DNS   ^DNS|2004012819021||QBP^Q11^QBP_Q11|65810481154|P|2.4|||AL|NE
      		QPD|K11^Allergies^HL70471|123996-11|123996|Allergies|2000010100000|2004123124000
      		PID|||1001023456^^^USVHA&&0363^NI^VA FACILITY ID&442&L~1477^^^USVHA&&0363^PI^VA FACILITY ID&442&L~123994321^^^USSSA&&0363^SS^VA FACILITY ID&200MH&L||TEST^HEATHER^J
      		RCP|D";
    */
    public String getSubjectArea() {
        return  SUBJECT_AREA_NAME;
    }     
   
    public int getQueryMode() {
        return QUERY_MODE_ASYNCHRONOUS;
    }
    
} 
