package gov.va.med.domain.service.messaging.encode.hl7;

/**
 * AdmissionEncoder
 * This will encode and fill QBP_Q13 Admission query by parameter message structure segments.
 * This query will generate a tabular response.
 *
 * @author John Nitz
 * @version $Id: AdmissionEncoder.java,v 1.2 2005/08/28 22:37:12 tom Exp $
 * @since MHV 2.0 <br>Jun , 2005
 */
public class AdmissionEncoder extends HL7TabularEncoder
{ 
    private static final String SUBJECT_AREA_NAME = "DischargeSummaries";
    private static final String[][] STRUCTURE = {
                             {"IEN", "NM", "30"},
                             {"Admission Date/Time", "TS", "26"},
                             {"Discharge Date/Time", "TS", "26"},
                             {"Verified Date/Time", "TS", "26"},
                             {"Amendment Date/Time", "TS", "26"},
                             {"Retraction Date/Time", "TS", "26"},
                             {"Parent", "NM", "30"},
							 {"Visit Location", "ST", "30"},
							 {"Treatment Speciality", "ST", "30"},
							 {"Finalization Date", "TS", "26"},
							 {"Cosignature Date/Time", "TS", "26"},
							 {"Amendment Signed Date/Time", "TS", "26"},
							 {"Status", "ST", "30"},
							 {"Report Text", "TX", "65535"}
							 };                              

    /*
      message = MSH|^~\&|EVET EVAULT|200HV^MHV.MED.DNS   ^DNS|EVET VISTA|442^CHY7D.DNS        .MED.DNS   ^DNS|2004012819021||QBP^Q13^QBP_Q13|65810481154|P|2.4|||AL|NE
      			QPD|K13^DischargeSummaries^HL70471|123996-8|123996|DischargeSummaries|2000010100000|2004123124000
      			PID|||1001023456^^^USVHA&&0363^NI^VA FACILITY ID&442&L~1477^^^USVHA&&0363^PI^VA FACILITY ID&442&L~123994321^^^USSSA&&0363^SS^VA FACILITY ID&200MH&L||TEST^HEATHER^J
      			RDF|7|IEN^NM^30~Admission Date/Time^TS^26~Discharge Date/Time^TS^26~Verified Date/Time^TS^26~Amendment Date/Time^TS^26~Retraction Date/Time^TS^26~Parent^NM^30~Visit Location^ST^30~Treating Specialty^ST^30~Report Text^TX^65535
      			RCP|D
    */
    public String getSubjectArea() {
        return  SUBJECT_AREA_NAME;
    }     

    public String[][] getColumnStructure()
    {
        return STRUCTURE;
    }
    
    public int getQueryMode() {
        return QUERY_MODE_ASYNCHRONOUS;
    };    
    
} 
