package gov.va.med.domain.service.messaging;

import gov.va.med.domain.model.IPayload;

/**
 * Used as a Status Response to hold the status and status description in 
 * addition to that which the Message holds. 
 * <P>
 * The isOk() reflects if the tranceive process succeeded.   This is different from whether 
 * the successful transcive returned an error reposonse such as a NAK.  Said another way
 * Response.isOk is a non-business error wheras the NAK or other error response is 
 * within the conext of the business.  
 *
 * @author Odysseas Pentakalos
 * @version $Id: Response.java,v 1.7 2005/07/13 12:59:54 slava.uchitel Exp $
 * @since MHV 2.0 <br>Mar 1, 2005
 */
public class Response extends Message implements IPayload
{
    private static final long serialVersionUID = 3617287947888964921L;
    // TODO redesign to capture an exception and perhaps have an ErrorResponse subclass.  The
    // TranceiverFacade would alos need to catch exceoption and put in response and the JMS Outbound
    // queue bean would need to query the response to  rethrow exception if  not OK.  
    private boolean ok;
    private String statusCode; 
    private String statusDescription;
     
    public Response(MessageType messageType, IPayload payload) {
        super(messageType, payload);
        setOk(true);
    }
    public Response(MessageType messageType, IPayload payload, boolean isOk) {
        super(messageType, payload);
        setOk(isOk);
    }
    
    public boolean isOk() {return ok;}
    
    public String getStatusDescription() { return statusDescription; }
    public void setStatusDescription(String statusDescription) {
        this.statusDescription = statusDescription;
    }
    public void setOk(boolean ok) {this.ok = ok;}
    public String getStatusCode() {return statusCode;}
    public void setStatusCode(String statusCode) {this.statusCode = statusCode;}
}
