package gov.va.med.domain.service.config;

import java.io.FileNotFoundException;
import java.sql.SQLException;

import javax.sql.DataSource;

import org.springframework.util.Assert;

import gov.va.med.domain.DomainConstants;
import gov.va.med.domain.service.MhvBaseService;
import gov.va.med.framework.IApplication;
import gov.va.med.framework.logging.LoggerFactory;
import gov.va.med.framework.lookup.MissingServiceException;
import gov.va.med.framework.lookup.ServiceLocator;
import gov.va.med.service.config.ConfigManager;
import gov.va.med.service.config.ConfigManagerException;

/**
 * Provides configuration services for MHV application in terms of retrieving values for 
 * MHV specific parameters in the predefined data types. It is an application stub for MHV and uses
 * ConfigManager class for basic operations.
 * 
 * @author Ramanand Singh
 * @version $Id: MhvConfigService.java,v 1.2 2005/07/18 14:37:39 jon.crater Exp $
 * @since MHV V2.0
 * @see ConfigManager
 */
public class MhvConfigService extends ConfigManager {
	private static MhvConfigService instance = null;
	private static IApplication app = null;
	private String loggerName;

	/**
	 * Gets an instance of the class. It creates a new one only if one does 
	 * not already exists
	 */
	public static MhvConfigService getInstance() {
		//Logger for bootstrapping
		MhvBaseService service = new MhvBaseService();
		synchronized (ConfigManager.class) {
			if(instance == null) {
				try {
					Class appClass = Class.forName("gov.va.med.framework.Application");
					app = (IApplication)appClass.newInstance();
					instance = new MhvConfigService();
					instance.setApplicationName(app.getApplicationName());
					instance.setLoggerName(app.getApplicationLoggerName());
				}
				catch (FileNotFoundException e) {
					// supress exception and log the error message
					throw new Error("Config file was not found.", e);
				}
				catch (ConfigManagerException e) {
					// suppress the exception and log the error message here 
					throw new Error("Error initializing the configuration parameters.", e);
				}
				catch (ClassNotFoundException e) {
					throw new Error(
							"The application must provide an implementation of the gov.va.med.framework.Application class.");
				}
				catch (InstantiationException e) {
					throw new Error(
							"The application must provide an implementation of the gov.va.med.framework.Application class.");
				}
				catch (IllegalAccessException e) {
					throw new Error(
							"The application must provide an implementation of the gov.va.med.framework.Application class.");
				}
			}
		}
		return instance;
	}

	/**
	 * supplies the name of the Application
	 */
	public void setApplicationName() {
		this.appName = app.getApplicationName();
		this.setApplication();
	}

	/**
	 * supplies the name of the IApplication
	 */
	private void setApplicationName(String appName) {
		this.appName = appName;
	}

	private void setLoggerName(String loggerName) {
		this.loggerName = loggerName;
	}

	/**
	 * creates a new instance of the class and sets the env and app names.
	 */
	protected MhvConfigService() throws FileNotFoundException, ConfigManagerException {
		super();
		this.setApplicationName();
		this.setEnvironmentName();
	}

	public String getLoggerName() {
		return loggerName;
	}

	public int getLoggerType() {
		return LoggerFactory.WL_NONCATALOG_LOGGER;
	}

	

	public DataSource getDataSource(String dataSourceName) {
		DataSource dataSource = null;

		if(dataSourceName != null) {
			try {
				dataSource = (DataSource)ServiceLocator.getInstance().getService(dataSourceName);
			}
			catch (MissingServiceException e) {
				MhvBaseService.getMhvLogger().error("Could not create DataSource with " + dataSourceName, e);
			}
		}
		return dataSource;
	}

	public String getRequiredValueString(String key) {
		String value = getParamValueString(key);
		Assert.notNull(value, "Required configuration value not mapped to key " + key);
		return value;
	}
}
