package gov.va.med.domain.persistence.jdbc.helper;

import gov.va.med.domain.service.messaging.environment.Destination;
import gov.va.med.domain.service.messaging.environment.EndPoint;

/**
 * EndpointEntry
 *
 * @author Odysseas Pentakalos
 * @version $Id: EndpointEntry.java,v 1.6 2005/08/03 20:18:08 joel.goldberg Exp $
 * @since MHV 2.0 <br>Mar 1, 2005
 */
public class EndpointEntry {
	private long destinationId;
	private long endpointId;
	private String protocolType;
	private String encodingType;
	private String transceiver;
	private long functionId;
	private String functionName;
	private String encoder;
	private String decoder;
	private String asyncDecoder;
	private String handler;
	private String aaEncoder;
	private String category;

	public String getAaEncoder() {
		return aaEncoder;
	}

	public void setAaEncoder(String aaEncoder) {
		this.aaEncoder = aaEncoder;
	}

	public String getAsyncDecoder() {
		return asyncDecoder;
	}

	public void setAsyncDecoder(String asyncDecoder) {
		this.asyncDecoder = asyncDecoder;
	}

	public String getCategory() {
		return category;
	}

	public void setCategory(String category) {
		this.category = category;
	}

	public String getHandler() {
		return handler;
	}

	public void setHandler(String handler) {
		this.handler = handler;
	}

	/**
	 * Extracts columns/field from this row and creates an 
	 * EndPoint.
	 * @param destination
	 */
	public EndPoint buildEndpoint(Destination destination) {
		EndPoint endpoint = new EndPoint(destination);
		endpoint.setEndpointId(this.getEndpointId());
		endpoint.setEncodingType(this.getEncodingType());
		endpoint.setProtocolType(this.getProtocolType());
		endpoint.setTransceiver(this.getTransceiver());
		return endpoint;
	}
	
	/**
	 * @return Returns the decoder.
	 */
	public String getDecoder() {
		return decoder;
	}

	/**
	 * @param decoder The decoder to set.
	 */
	public void setDecoder(String decoder) {
		this.decoder = decoder;
	}

	/**
	 * @return Returns the destinationId.
	 */
	public long getDestinationId() {
		return destinationId;
	}

	/**
	 * @param destinationId The destinationId to set.
	 */
	public void setDestinationId(long destinationId) {
		this.destinationId = destinationId;
	}

	/**
	 * @return Returns the encoder.
	 */
	public String getEncoder() {
		return encoder;
	}

	/**
	 * @param encoder The encoder to set.
	 */
	public void setEncoder(String encoder) {
		this.encoder = encoder;
	}

	/**
	 * @return Returns the endpointId.
	 */
	public long getEndpointId() {
		return endpointId;
	}

	/**
	 * @param endpointId The endpointId to set.
	 */
	public void setEndpointId(long endpointId) {
		this.endpointId = endpointId;
	}

	/**
	 * @return Returns the functionName.
	 */
	public String getFunctionName() {
		return functionName;
	}

	/**
	 * @param functionName The functionName to set.
	 */
	public void setFunctionName(String functionName) {
		this.functionName = functionName;
	}

	/**
	 * @return Returns the encodingType.
	 */
	public String getEncodingType() {
		return encodingType;
	}

	/**
	 * @param encodingType The encodingType to set.
	 */
	public void setEncodingType(String encodingType) {
		this.encodingType = encodingType;
	}

	/**
	 * @return Returns the functionId.
	 */
	public long getFunctionId() {
		return functionId;
	}

	/**
	 * @param functionId The functionId to set.
	 */
	public void setFunctionId(long functionId) {
		this.functionId = functionId;
	}

	/**
	 * @return Returns the protocolType.
	 */
	public String getProtocolType() {
		return protocolType;
	}

	/**
	 * @param protocolType The protocolType to set.
	 */
	public void setProtocolType(String protocolType) {
		this.protocolType = protocolType;
	}

	/**
	 * @return Returns the transceiver.
	 */
	public String getTransceiver() {
		return transceiver;
	}

	/**
	 * @param transceiver The transceiver to set.
	 */
	public void setTransceiver(String transceiver) {
		this.transceiver = transceiver;
	}
}
