package gov.va.med.domain.persistence.jdbc.helper;

import gov.va.med.domain.service.messaging.environment.Destination;

/**
 * DestinationEntry
 *
 * @author Odysseas Pentakalos
 * @version $Id: DestinationEntry.java,v 1.4 2005/07/19 14:58:48 joel.goldberg Exp $
 * @since MHV 2.0 <br>Mar 1, 2005
 */
public class DestinationEntry
{
	private long destinationId;
	private long institutionId;
	private String otherDestinationName;
	private String stationNumber;
	private String vistaName;
	private String name;
    private String active;
    private String participating;
    private String version;
	
    public Destination getDestination() {
        Destination destination = new Destination();
        destination.setDestinationId(this.getDestinationId());
        destination.setInstitutionId(this.getInstitutionId()); 
        destination.setActive(getActive().equalsIgnoreCase("Y"));
        
        if (destination.getInstitutionId() == 0) {
            destination.setDestinationKey(this.getOtherDestinationName());
            destination.setName(this.getOtherDestinationName());
        } else {
            destination.setDestinationKey(this.getStationNumber());
            destination.setName(this.getName());
        }
        destination.setParticipating(participating.equalsIgnoreCase("Y"));
        destination.setVersion(version);
        return destination;
    }
    
	/**
	 * @return Returns the institutionId.
	 */
	public long getInstitutionId() {
		return institutionId;
	}
	/**
	 * @param institutionId The institutionId to set.
	 */
	public void setInstitutionId(long institutionId) {
		this.institutionId = institutionId;
	}
	/**
	 * @return Returns the name.
	 */
	public String getName() {
		return name;
	}
	/**
	 * @param name The name to set.
	 */
	public void setName(String name) {
		this.name = name;
	}
	/**
	 * @return Returns the otherDestinationName.
	 */
	public String getOtherDestinationName() {
		return otherDestinationName;
	}
	/**
	 * @param otherDestinationName The otherDestinationName to set.
	 */
	public void setOtherDestinationName(String otherDestinationName) {
		this.otherDestinationName = otherDestinationName;
	}
	/**
	 * @return Returns the stationNumber.
	 */
	public String getStationNumber() {
		return stationNumber;
	}
	/**
	 * @param stationNumber The stationNumber to set.
	 */
	public void setStationNumber(String stationNumber) {
		this.stationNumber = stationNumber;
	}
	/**
	 * @return Returns the vistaName.
	 */
	public String getVistaName() {
		return vistaName;
	}
	/**
	 * @param vistaName The vistaName to set.
	 */
	public void setVistaName(String vistaName) {
		this.vistaName = vistaName;
	}
	/**
	 * @return Returns the destinationId.
	 */
	public long getDestinationId() {
		return destinationId;
	}
	/**
	 * @param destinationId The destinationId to set.
	 */
	public void setDestinationId(long destinationId) {
		this.destinationId = destinationId;
	}

    /**
     * @return Returns the active.
     */
    public String getActive() {
        return active;
    }
    

    /**
     * @param active The active to set.
     */
    public void setActive(String active) {
        this.active = active;
    }
    
    /**
     * @return Returns the participating.
     */
    public String getParticipating()
    {
        return participating;
    }
    /**
     * @param participating The participating to set.
     */
    public void setParticipating(String participating)
    {
        this.participating = participating;
    }
    /**
     * @return Returns the version.
     */
    public String getVersion()
    {
        return version;
    }
    /**
     * @param version The version to set.
     */
    public void setVersion(String version)
    {
        this.version = version;
    }
}
