package gov.va.med.domain.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;

import org.apache.commons.lang3.builder.ToStringBuilder;


/** 
 *        @hibernate.class
 *         table="STATES"
 *     
*/
public class State implements Serializable {

    /** identifier field */
    private BigDecimal stateId;

    /** persistent field */
    private String name;

    /** nullable persistent field */
    private String postalName;

    /** nullable persistent field */
    private String fipscode;

    /** persistent field */
    private BigDecimal version;

    /** persistent field */
    private Date createdDate;

    /** nullable persistent field */
    private Date modifiedDate;

    /** persistent field */
    private Set institutions;

    /** full constructor */
    public State(BigDecimal stateId, String name, String postalName, String fipscode, BigDecimal version, Date createdDate, Date modifiedDate, Set institutions) {
        this.stateId = stateId;
        this.name = name;
        this.postalName = postalName;
        this.fipscode = fipscode;
        this.version = version;
        this.createdDate = createdDate;
        this.modifiedDate = modifiedDate;
        this.institutions = institutions;
    }

    /** default constructor */
    public State() {
    }

    /** minimal constructor */
    public State(BigDecimal stateId, String name, BigDecimal version, Date createdDate, Set institutions) {
        this.stateId = stateId;
        this.name = name;
        this.version = version;
        this.createdDate = createdDate;
        this.institutions = institutions;
    }

    /** 
     *            @hibernate.id
     *             generator-class="assigned"
     *             type="java.math.BigDecimal"
     *             column="STATE_ID"
     *         
     */
    public BigDecimal getStateId() {
        return this.stateId;
    }

    public void setStateId(BigDecimal stateId) {
        this.stateId = stateId;
    }

    /** 
     *            @hibernate.property
     *             column="NAME"
     *             length="50"
     *             not-null="true"
     *         
     */
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    /** 
     *            @hibernate.property
     *             column="POSTAL_NAME"
     *             length="30"
     *         
     */
    public String getPostalName() {
        return this.postalName;
    }

    public void setPostalName(String postalName) {
        this.postalName = postalName;
    }

    /** 
     *            @hibernate.property
     *             column="FIPSCODE"
     *             length="2"
     *         
     */
    public String getFipscode() {
        return this.fipscode;
    }

    public void setFipscode(String fipscode) {
        this.fipscode = fipscode;
    }

    /** 
     *            @hibernate.property
     *             column="VERSION"
     *             length="22"
     *             not-null="true"
     *         
     */
    public BigDecimal getVersion() {
        return this.version;
    }

    public void setVersion(BigDecimal version) {
        this.version = version;
    }

    /** 
     *            @hibernate.property
     *             column="CREATED_DATE"
     *             length="7"
     *             not-null="true"
     *         
     */
    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    /** 
     *            @hibernate.property
     *             column="MODIFIED_DATE"
     *             length="7"
     *         
     */
    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    public void setModifiedDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    /** 
     *            @hibernate.set
     *             lazy="true"
     *             inverse="true"
     *             cascade="none"
     *            @hibernate.collection-key
     *             column="STATE_ID"
     *            @hibernate.collection-one-to-many
     *             class="gov.va.med.domain.model.Institution"
     *         
     */
    public Set getInstitutions() {
        return this.institutions;
    }

    public void setInstitutions(Set institutions) {
        this.institutions = institutions;
    }

    public String toString() {
        return new ToStringBuilder(this)
            .append("stateId", getStateId())
            .toString();
    }

}
