package gov.va.med.domain.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

 
/** 
 *        @hibernate.class
 *         table="INSTITUTIONS"
 *     
*/
public class Institution extends gov.va.med.domain.model.DomainObject implements Serializable {


    /** persistent field */
    private String name;

    /** persistent field */
    private String vistaName;

    /** nullable persistent field */
    private String stationNumber;

    /** nullable persistent field */
    private Date archivedDate;

    /** persistent field */
    private gov.va.med.domain.model.Institution parentInstitution;

    /** persistent field */
    private Set childInstitutions;

    /** nullable persistent field */
    private String city;
    
    /** persistent field */
    private gov.va.med.domain.model.State state;
    
    /** nullable persistent field */
    private String mhvName;

    /** nullable persistent field */
    private BigDecimal visnId;

    /** nullable persistent field */
    private BigDecimal facilitytypeId;

    /** nullable persistent field */
    private BigDecimal agencyId;

    /** nullable persistent field */
    private Date activationdate;

    /** nullable persistent field */
    private Date deactivationdate;

    /** nullable persistent field */
    private String facilityPhoneNumber;

    /** nullable persistent field */
    private String facilityInternetUrl;

    /** nullable persistent field */
    private String facilityIntranetUrl;
    
    
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVistaName() {
        return this.vistaName;
    }

    public void setVistaName(String vistaName) {
        this.vistaName = vistaName;
    }

    public String getStationNumber() {
        return this.stationNumber;
    }

    public void setStationNumber(String stationNumber) {
        this.stationNumber = stationNumber;
    }

 
    public Date getArchivedDate() {
        return this.archivedDate;
    }

    public void setArchivedDate(Date archivedDate) {
        this.archivedDate = archivedDate;
    }
    
    /**
	 * @return Returns the city.
	 */
	public String getCity() {
		return city;
	}
	/**
	 * @param city The city to set.
	 */
	public void setCity(String city) {
		this.city = city;
	}
   

     /** 
     *            @hibernate.many-to-one
     *             not-null="true"
     *            @hibernate.column name="PARENT_INSTITUTION_ID"         
     *         
     */
    public gov.va.med.domain.model.Institution getParentInstitution() {
        return this.parentInstitution;
    }

    public void setParentInstitution(gov.va.med.domain.model.Institution parentInstitution) {
        this.parentInstitution = parentInstitution;
    }

    /** 
     *            @hibernate.set
     *             lazy="true"
     *             inverse="true"
     *             cascade="none"
     *            @hibernate.collection-key
     *             column="PARENT_INSTITUTION_ID"
     *            @hibernate.collection-one-to-many
     *             class="gov.va.med.domain.model.Institution"
     *         
     */
    public Set getChildInstitutions() {
        return this.childInstitutions;
    }

    public void setChildInstitutions(Set childInstitutions) {
        this.childInstitutions = childInstitutions;
    }
    
    /** 
     *            @hibernate.many-to-one
     *            @hibernate.column name="STATE_ID"               
     */
    public gov.va.med.domain.model.State getState() {
        return this.state;
    }

    public void setState(gov.va.med.domain.model.State state) {
        this.state = state;
    }
    
    /** 
     *            @hibernate.property
     *             column="MHV_NAME"
     *             length="255"
     *         
     */
    public String getMhvName() {
        return this.mhvName;
    }

    public void setMhvName(String mhvName) {
        this.mhvName = mhvName;
    }

    /** 
     *            @hibernate.property
     *             column="VISN_ID"
     *             length="22"
     *         
     */
    public BigDecimal getVisnId() {
        return this.visnId;
    }

    public void setVisnId(BigDecimal visnId) {
        this.visnId = visnId;
    }

    /** 
     *            @hibernate.property
     *             column="FACILITYTYPE_ID"
     *             length="22"
     *         
     */
    public BigDecimal getFacilitytypeId() {
        return this.facilitytypeId;
    }

    public void setFacilitytypeId(BigDecimal facilitytypeId) {
        this.facilitytypeId = facilitytypeId;
    }

    /** 
     *            @hibernate.property
     *             column="AGENCY_ID"
     *             length="22"
     *         
     */
    public BigDecimal getAgencyId() {
        return this.agencyId;
    }

    public void setAgencyId(BigDecimal agencyId) {
        this.agencyId = agencyId;
    }

    /** 
     *            @hibernate.property
     *             column="ACTIVATIONDATE"
     *             length="7"
     *         
     */
    public Date getActivationdate() {
        return this.activationdate;
    }

    public void setActivationdate(Date activationdate) {
        this.activationdate = activationdate;
    }

    /** 
     *            @hibernate.property
     *             column="DEACTIVATIONDATE"
     *             length="7"
     *         
     */
    public Date getDeactivationdate() {
        return this.deactivationdate;
    }

    public void setDeactivationdate(Date deactivationdate) {
        this.deactivationdate = deactivationdate;
    }

    /** 
     *            @hibernate.property
     *             column="FACILITY_PHONE_NUMBER"
     *             length="50"
     *         
     */
    public String getFacilityPhoneNumber() {
        return this.facilityPhoneNumber;
    }

    public void setFacilityPhoneNumber(String facilityPhoneNumber) {
        this.facilityPhoneNumber = facilityPhoneNumber;
    }

    /** 
     *            @hibernate.property
     *             column="FACILITY_INTERNET_URL"
     *             length="255"
     *         
     */
    public String getFacilityInternetUrl() {
        return this.facilityInternetUrl;
    }

    public void setFacilityInternetUrl(String facilityInternetUrl) {
        this.facilityInternetUrl = facilityInternetUrl;
    }

    /** 
     *            @hibernate.property
     *             column="FACILITY_INTRANET_URL"
     *             length="255"
     *         
     */
    public String getFacilityIntranetUrl() {
        return this.facilityIntranetUrl;
    }

    public void setFacilityIntranetUrl(String facilityIntranetUrl) {
        this.facilityIntranetUrl = facilityIntranetUrl;
    }


    public String toString() {
        return new ToStringBuilder(this)
            .append("id", getId())
            .append("name", getName())
            .append("vistaName", getVistaName())
            .append("mhvName", getMhvName())
            .append("visnId", getVisnId())
			.append("facilityTypeId", getFacilitytypeId())
            .toString();
    }

    public boolean equals(Object other) {
        if ( (this == other ) ) return true;
        if ( !(other instanceof Institution) ) return false;
        Institution castOther = (Institution) other;
        return new EqualsBuilder()
            .append(this.getId(), castOther.getId())
            .append(this.getName(), castOther.getName())
            .append(this.getVistaName(), castOther.getVistaName())
            .append(this.getStationNumber(), castOther.getStationNumber())
            .append(this.getVersionNumber(), castOther.getVersionNumber())
            .append(this.getParentInstitution(), castOther.getParentInstitution())
            .isEquals();
    }

    
	public long getLongId() {
	    return ((Long)getId()).longValue();
	}
	public Institution() {
	}
	/**
	 * Special construction to allow convenient creation from 
	 * a Station Number using the InstitutionStationNumberMapper
	 * @param stationNumber
	 */
	public Institution(String aStationNumber) {
	    setStationNumber(aStationNumber);
	}
	
	
	
	
}
