package gov.va.med.domain.model;

import gov.va.med.framework.bean.AbstractVO;

/**
 * HL7Error
 * HL7Errors
 * 
 *
 * @author Slava Uchitel
 * @version $Id: HL7Error.java,v 1.1.1.1 2005/05/13 19:40:35 jon.crater Exp $
 * @since MHV 2.0 <br>03/17/2005
 */

public class HL7Error extends AbstractVO
{ 

    private static final long serialVersionUID = 3258128046564586552L;
    public static final int OK_STATUS = 0;
    public static final int UNKNOWN_ERROR = -99999;
    
    private static final String[] errorDescriptions =
       { 
        "Ok",
        "Missing Patient ID",
        "Missing QPD segment",
        "Missing RCP segment",
        "Missing Message Query Name",
        "Missing Query Tag", 
        "Missing Request ID",
        "Missing ICN",
        "Invalid ICN",
        "Invalid SSN",
        "Patient Not Found",
        "DFN/ICN Mismatch",
        "Missing Request Type",
        "Request Type Not Found", 
        "Invalid From Date",
        "Invalid To Date",
        "To Date precedes From Date",
        "Missing Query Priority",
        "Invalid Query Priority",
        "Query Priority Mismatch",
        "Request Type Blocked by Site",
        "Real Time Query Not Supported By Request Type",
        "Appointment Extract Error: ",
        "Copay Balance Extract Error: ",
        "Copay Detail Extract Error: "
    };
    
    public static int getErrorStatusFromDescription(String description)
    {
        if (description==null || description.length()==0)
          return 0;
        for (int i=0; i<errorDescriptions.length; i++)
        {
            if (errorDescriptions[i].startsWith(description))
              return -i;
        }
        return - 99999;
    } 
    
    public static String getErrorDescriptionFromStatus(int status)
    {
        int j=-status;
        if (j>=0 && j<errorDescriptions.length)
            return errorDescriptions[j];
        return "Unknown Error";
    }
} 
