package gov.va.med.domain.model;

import java.util.Set;

import org.apache.commons.lang3.builder.ToStringBuilder;


/** 
 *        @hibernate.class
 *         table="CATEGORY_TYPES"
 *     
*/
public class CategoryType extends DomainObject {

    /** persistent field */
    private String description;

    /** persistent field */
    private String holdForReviewInd;

    /** persistent field */
    private String initialDelayInd;

    /** nullable persistent field */
    private Integer delayPeriod;

    /** persistent field */
    private Set functions;

    /** persistent field */
    private Set categoryActivities;

    /** full constructor */
    public CategoryType(String id, String description, String holdForReviewInd, String initialDelayInd, Integer delayPeriod, Set functions, Set categoryActivities) {
        this.setId(id);
        this.description = description;
        this.holdForReviewInd = holdForReviewInd;
        this.initialDelayInd = initialDelayInd;
        this.delayPeriod = delayPeriod;
        this.functions = functions;
        this.categoryActivities = categoryActivities;
    }

    /** default constructor */
    public CategoryType() {
    }

    /** minimal constructor */
    public CategoryType(String id, String description, String holdForReviewInd, String initialDelayInd, Set functions, Set categoryActivities) {
        this.setId(id);
        this.description = description;
        this.holdForReviewInd = holdForReviewInd;
        this.initialDelayInd = initialDelayInd;
        this.functions = functions;
        this.categoryActivities = categoryActivities;
    }
    
    /** 
     *            @hibernate.property
     *             column="DESCRIPTION"
     *             update="false"
     *             insert="false"
     *             length="50"
     *             not-null="true"
     *         
     */
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    /** 
     *            @hibernate.property
     *             column="HOLD_FOR_REVIEW_IND"
     *             update="false"
     *             insert="false"
     *             length="1"
     *             not-null="true"
     *         
     */
    public String getHoldForReviewInd() {
        return this.holdForReviewInd;
    }

    public void setHoldForReviewInd(String holdForReviewInd) {
        this.holdForReviewInd = holdForReviewInd;
    }

    /** 
     *            @hibernate.property
     *             column="INITIAL_DELAY_IND"
     *             update="false"
     *             insert="false"
     *             length="1"
     *             not-null="true"
     *         
     */
    public String getInitialDelayInd() {
        return this.initialDelayInd;
    }

    public void setInitialDelayInd(String initialDelayInd) {
        this.initialDelayInd = initialDelayInd;
    }

    /** 
     *            @hibernate.property
     *             column="DELAY_PERIOD"
     *             update="false"
     *             insert="false"
     *             length="3"
     *         
     */
    public Integer getDelayPeriod() {
        return this.delayPeriod;
    }

    public void setDelayPeriod(Integer delayPeriod) {
        this.delayPeriod = delayPeriod;
    }

    /** 
     *            @hibernate.set
     *             lazy="true"
     *             inverse="true"
     *             cascade="none"
     *            @hibernate.collection-key
     *             column="CATEGORY_CODE"
     *            @hibernate.collection-one-to-many
     *             class="gov.va.med.domain.model.Function"
     *         
     */
    public Set getFunctions() {
        return this.functions;
    }

    public void setFunctions(Set functions) {
        this.functions = functions;
    }

    /** 
     *            @hibernate.set
     *             lazy="true"
     *             inverse="true"
     *             cascade="none"
     *            @hibernate.collection-key
     *             column="CATEGORY_CODE"
     *            @hibernate.collection-one-to-many
     *             class="gov.va.med.domain.model.CategoryActivity"
     *         
     */
    public Set getCategoryActivities() {
        return this.categoryActivities;
    }

    public void setCategoryActivities(Set categoryActivities) {
        this.categoryActivities = categoryActivities;
    }

    public String toString() {
        return new ToStringBuilder(this)
            .append("id", getId())
            .append("description", getDescription())
            .append("holdForReviewInd", getHoldForReviewInd())
            .append("initialDelayInd", getInitialDelayInd())
            .append("delayPeriod", getDelayPeriod())
            .toString();
    }

}
