package gov.va.med.domain.model;

import gov.va.med.domain.typecode.AddressTypeCode;

import java.io.Serializable;
import java.math.BigDecimal;

import org.apache.commons.lang3.builder.ToStringBuilder;


/** @author Hibernate CodeGenerator */
public class Address implements Serializable {

    /** identifier field */
    private BigDecimal addressIdSeq;

    /** persistent field */
    private AddressTypeCode addressType;

    /** nullable persistent field */
    private String addressLine1;

    /** nullable persistent field */
    private String addressLine2;

    /** nullable persistent field */
    private String city;

    /** nullable persistent field */
    private BigDecimal stateId;

    /** nullable persistent field */
    private BigDecimal countryId;

    /** nullable persistent field */
    private String zipCode;

    /** nullable persistent field */
    private String province;

    /** nullable persistent field */
    private Long userId;

    /** full constructor */
    public Address(BigDecimal addressIdSeq, AddressTypeCode addressType, String addressLine1, String addressLine2, String city, BigDecimal stateId, BigDecimal countryId, String zipCode, String province, Long userId) {
        this.addressIdSeq = addressIdSeq;
        this.addressType = addressType;
        this.addressLine1 = addressLine1;
        this.addressLine2 = addressLine2;
        this.city = city;
        this.stateId = stateId;
        this.countryId = countryId;
        this.zipCode = zipCode;
        this.province = province;
        this.userId = userId;
    }

    /** default constructor */
    public Address() {
    }

    /** minimal constructor */
    public Address(BigDecimal addressIdSeq, AddressTypeCode addressType) {
        this.addressIdSeq = addressIdSeq;
        this.addressType = addressType;
    }

    public BigDecimal getAddressIdSeq() {
        return this.addressIdSeq;
    }

    public void setAddressIdSeq(BigDecimal addressIdSeq) {
        this.addressIdSeq = addressIdSeq;
    }

    public String getAddressLine1() {
        return this.addressLine1;
    }

    public void setAddressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
    }

    public String getAddressLine2() {
        return this.addressLine2;
    }

    public void setAddressLine2(String addressLine2) {
        this.addressLine2 = addressLine2;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public BigDecimal getStateId() {
        return this.stateId;
    }

    public void setStateId(BigDecimal stateId) {
        this.stateId = stateId;
    }

    public BigDecimal getCountryId() {
        return this.countryId;
    }

    public void setCountryId(BigDecimal countryId) {
        this.countryId = countryId;
    }

    public String getZipCode() {
        return this.zipCode;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    public String getProvince() {
        return this.province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String toString() {
        return new ToStringBuilder(this)
            .append("addressIdSeq", getAddressIdSeq())
            .toString();
    }

    public AddressTypeCode getAddressType() {
        return addressType;
    }

    public void setAddressType(AddressTypeCode addressType) {
        this.addressType = addressType;
    }

}
