package gov.va.med.mhv.rxrefill.data.sort;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

import gov.va.med.mhv.rxrefill.data.model.Prescription;

public class PrescriptionChainedComparator implements Comparator<Prescription> {

	private List<Comparator<Prescription>> listComparators;

	@SafeVarargs
	public PrescriptionChainedComparator(Comparator<Prescription>... comparators) {
		this.listComparators = Arrays.asList(comparators);
	}

	@Override
	public int compare(Prescription rx1, Prescription rx2) {
		for (Comparator<Prescription> comparator : listComparators) {
			int result = comparator.compare(rx1, rx2);
			if (result != 0) {
				return result;
			}
		}
		return 0;
	}
}
