package gov.va.med.mhv.rxrefill.data.repository;

import gov.va.med.mhv.rxrefill.data.model.Prescription;
import gov.va.med.mhv.rxrefill.data.model.RxTracking;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface RxTrackingRepository extends JpaRepository<RxTracking, Long>{
	
	@Query("select rx " +
			"from RxTracking rx " +
			"where rx.rxNumber = :rxNumber " +
			"order by rx.completeDateTime desc")	
	public List<RxTracking> getTrackingDetails(@Param("rxNumber") String rxNumber);
	
	
	@Query("select rx " +
			"from RxTracking rx " +
			"where rx.rxNumber = :rxNumber " +
			"and rx.stationNumber = :stationNumber " + 
			"order by rx.completeDateTime desc, rx.stationNumber, rx.rxNumber, rx.carrier, rx.trackingNumber, rx.divisionPhone, rx.ndc"
		   )		
	public List<RxTracking> getPrescriptionTrackingBySiteAndRxNumber(
					@Param("stationNumber") String stationNumber, 
					@Param("rxNumber") String rxNumber);

	@Query("select rxtrack " +
			"from RxTracking rxtrack " +
			"where rxtrack.trackingNumber = :trackingNumber " +
			"order by rxtrack.completeDateTime desc, rxtrack.stationNumber, rxtrack.rxNumber, rxtrack.carrier, rxtrack.trackingNumber, rxtrack.divisionPhone, rxtrack.ndc"
		   )		
	public List<RxTracking> getPrescriptionDataByTrackingNumber(
					@Param("trackingNumber") String trackingNumber);

}