package gov.va.med.mhv.rxrefill.data.repository;

import gov.va.med.mhv.rxrefill.data.model.PharmacyPatient;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface PharmacyPatientRepository extends JpaRepository<PharmacyPatient, Long> {

	@Query("select pp from PharmacyPatient pp, Patient p where pp.patientId = p.id and p.userProfileId = :userProfileId")
	PharmacyPatient getPharmacyPatient(@Param("userProfileId") Long userProfileId);
	
}
