package gov.va.med.mhv.rxrefill.data.repository;

import gov.va.med.mhv.rxrefill.data.model.MedicationHistory;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface MedicataionHistoryRepository extends JpaRepository<MedicationHistory, Long>{
	
	@Query("select m " +
		    "from MedicationHistory m "+
		    "where m.userId = :userId " +
			"order by UPPER(m.category) asc, UPPER(m.medicationName) asc, m.dosage asc, m.startDate desc, m.endDate desc, m.prescriptionNumber asc")
	public List<MedicationHistory> getMedicationsByUserId(@Param("userId") Long userId);
}