package gov.va.med.mhv.rxrefill.data.repository;

import gov.va.med.mhv.rxrefill.data.model.Institution;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface InstitutionRepository extends JpaRepository<Institution, Long> {
	
	@Query("select i " +
			"from Institution i " +
			"where i.stationNumber = :stationNumber")
	public List<Institution> getInstitutionForStationNumber(@Param("stationNumber") String stationNumber);

	
	@Query("select i " +
			"from Institution i " +
			"where i.institutionId = :institutionId")
	public List<Institution> getInstitutionForInstitutionId(@Param("institutionId") Long institutionId);

}
