package gov.va.med.mhv.rxrefill.data.model;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

import gov.va.med.mhv.common.data.model.Patient;

@Entity
@Table(name = "PHARM_PATIENT")
public class PharmacyPatient implements Serializable {

	private static final long serialVersionUID = -7800778303865374335L;
	private static Logger log = LogManager.getLogger(PharmacyPatient.class);

	@Id
	@Column(name = "PHARM_PATIENT_ID")
	private Long id;

	@Column(name = "OPLOCK")
	private Integer oplock = 1;

	@Column(name = "PATIENT_PATIENT_ID", insertable = false, updatable = false)
	private Long patientId;

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "PATIENT_PATIENT_ID")
	private Patient patient;

	@OneToMany(mappedBy = "parentPharmacyPatient", fetch = FetchType.EAGER)
	@Fetch(FetchMode.SELECT)
	private Set<PharmPatientChange> pharmacyPatientChanges;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public Long getPatientId() {
		return patientId;
	}

	public void setPatientId(Long patientId) {
		this.patientId = patientId;
	}

	public Patient getPatient() {
		return patient;
	}

	public void setPatient(Patient patient) {
		this.patient = patient;
	}

	public Set<PharmPatientChange> getPharmacyPatientChanges() {
		if( pharmacyPatientChanges == null ) {
			pharmacyPatientChanges = new HashSet<PharmPatientChange>();
		}
		return pharmacyPatientChanges;
	}

	public void setPharmacyPatientChanges(
			Set<PharmPatientChange> pharmacyPatientChanges) {
		this.pharmacyPatientChanges = pharmacyPatientChanges;
	}
	
	/**
	 * Add a pharmacyPatientChange
	 *
	 * @param The pharmacyPatientChange to add
	 */
	public void addPharmacyPatientChange(PharmPatientChange pharmacyPatientChange) {
		Set<PharmPatientChange> childSet = getPharmacyPatientChanges();
		if (childSet == null) {
			childSet = new HashSet<PharmPatientChange>();
			setPharmacyPatientChanges(childSet);
		}
		
		pharmacyPatientChange.setParentPharmacyPatient( (PharmacyPatient) this );
		childSet.add( pharmacyPatientChange );
	}
	 
	/**
	 * Remove a pharmacyPatientChange
	 *
	 * @param The pharmacyPatientChange to remove
	 */
	public PharmPatientChange removePharmacyPatientChange(PharmPatientChange pharmacyPatientChange) {
		if( getPharmacyPatientChanges().remove( pharmacyPatientChange ) ) {
			pharmacyPatientChange.setParentPharmacyPatient(null);
		} else {
			log.error("Could not remove pharmacyPatientChange instance with key " + pharmacyPatientChange.getId());
		}
	    
		return pharmacyPatientChange;
	}
}
