package gov.va.med.mhv.rxrefill.data.model;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name = "DESTINATIONS")
public class Destination implements Serializable {

	private static final long serialVersionUID = 437498251428462767L;

	@Id
	@Column(name = "DESTINATION_ID_SEQ")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long id;

	@Column(name = "OTHER_DESTINATION_NAME")
	private String otherDestinationName;

	@Column(name = "CURRENT_IND")
	private String active;

	@Column(name = "MHV_VERSION_AT_SITE")
	private String mhvVersion;

	@Column(name = "PARTICIPATION_IND")
	private String participating;

	@Column(name = "INSTITUTION_ID", insertable = false, updatable = false)
	private Long institutionId;

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "INSTITUTION_ID")
	private Institutions institution;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getOtherDestinationName() {
		return otherDestinationName;
	}

	public void setOtherDestinationName(String otherDestinationName) {
		this.otherDestinationName = otherDestinationName;
	}

	public String getActive() {
		return active;
	}

	public void setActive(String active) {
		this.active = active;
	}

	public String getMhvVersion() {
		return mhvVersion;
	}

	public void setMhvVersion(String mhvVersion) {
		this.mhvVersion = mhvVersion;
	}

	public String getParticipating() {
		return participating;
	}

	public void setParticipating(String participating) {
		this.participating = participating;
	}

	public Long getInstitutionId() {
		return institutionId;
	}

	public void setInstitutionId(Long institutionId) {
		this.institutionId = institutionId;
	}

	public Institutions getInstitution() {
		return institution;
	}

	public void setInstitution(Institutions institution) {
		this.institution = institution;
	}
}
