package gov.va.med.mhv.rxrefill.service;

import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.rxrefill.dto.MedicationHistoryDTO;

import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.springframework.stereotype.Service;

@Path("/")
@Service("medicationSupplementService")
public interface MedicationSupplementService {

	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/ping/{sampleText}")
	public String test(@PathParam("sampleText") String sampleText) throws MHVException;

	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/medications/{userId}")
	public List<MedicationHistoryDTO> getMedicationsByUserId(@PathParam("userId") Long userId) throws MHVException;
	
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/medication/{medicationId}")
	public MedicationHistoryDTO getMedicationsById(@PathParam("medicationId") Long medicationId) throws MHVException;
	
	@POST
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	@Path("/medication")
	public MedicationHistoryDTO saveMedication(MedicationHistoryDTO medication) throws MHVException;
	
	@DELETE
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/medication/{medicationId}")
	public ResponseUtil deleteMedication(@PathParam("medicationId") Long medicationId) throws MHVException;
}