package gov.va.med.mhv.rxrefill.enums;


public enum RequestFunctionEnumeration { 

	GETICN("getICN", 1),
	REFILLPRESCRIPTION("refillPrescription", 2),
	GETPRESCRIPTIONSTATUS("getPrescriptionStatus", 3),
	GETPRESCRIPTIONPROFILE("getPrescriptionProfile", 4),
	GETPRESCRIPTIONUPDATE("getPrescriptionUpdate", 50);

	private String description;
	private int value;

	RequestFunctionEnumeration(String description, int value) {
		this.description = description;
		this.value = value;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public int getValue() {
		return value;
	}

	public void setValue(int value) {
		this.value = value;
	}
	
	public static RequestFunctionEnumeration fromValue(int v) {
        for (RequestFunctionEnumeration c: RequestFunctionEnumeration.values()) {
            if (c.value == v) {
                return c;
            }
        }
        throw new IllegalArgumentException(String.valueOf(v));
    }
}
