package gov.va.med.mhv.rxrefill.enums;



public enum PrescriptionStatusEnumeration {
	ACTIVE("active","Active"),
	SUBMITTED("submitted","Submitted"),
	SUSPENDED("suspended","Refill in Process"),
	REFILLINPROCESS("refillinprocess","Refill in Process"),
	NONVERIFIED("nonVerified","NonVerified"),
	HOLD("hold","Hold"),
	EXPIRED("expired","Expired"),
	DISCONTINUED("discontinued","Discontinued"),
	DISCONTINUEDBYPROVIDER("discontinuedByProvider","DiscontinuedByProvider"),
	PROVIDERHOLD("providerHold","ProviderHold"),
	DISCONTINUEDEDIT("discontinuedEdit","DiscontinuedEdit"),
	DELETED("deleted","Deleted"),
	UNKNOWN("unknown","Unknown");

	private String value;
	private String description;

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	PrescriptionStatusEnumeration(String value, String description){
		this.value = value;
		this.description = description;
	}

	public static PrescriptionStatusEnumeration fromValue(String value) {
        for (PrescriptionStatusEnumeration status: PrescriptionStatusEnumeration.values()) {
            if (status.value.equalsIgnoreCase(value)) {
                return status;
            }
        }
        throw new IllegalArgumentException(value);
    }
}
