package gov.va.med.mhv.rxrefill.dto;

import gov.va.med.mhv.rxrefill.enums.PrescriptionStatusEnumeration;
import gov.va.med.mhv.rxrefill.utils.WebUtility;
import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.rxrefill.dto.RxTrackingDTO;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 * Transfer object for the Prescription application entity.
 * 
 */
@SuppressWarnings("unused")
public class PrescriptionDTO implements Serializable {
	private static final long serialVersionUID = 1176157257582915937L;
	private static final String DISP_DATE_FORMAT = "MM/dd/yyyy";

	private Long id;
	private Date createdDate;
	private Boolean isRefillable;
	private String placerOrderNumber;
	private Long userId;
	private UserProfileDTO userProfile;
	private String ien;
	private String providerFirstName;
	private String providerId;
	private Long division;
	private Boolean isInactive;
	private String sig;
	private String mailWindow;
	private Date releaseDateTime;
	private Boolean isInvalidMhvStatus;
	private String prescriptionNumber;
	private Date expirationCancelDate;
	private String providerLastName;
	private BigDecimal quantity;
	private Date mhvStatusDate;
	private Date lastFillDate;
	private String remarks;
	private String status;
	private Integer daysSupply;
	private Date lastRefillSubmittedDate;
	private String divisionName;
	private Date archivedDate;
	private String drugName;
	private Date modifiedDate;
	private Integer numberOfRefills;
	private Integer mhvStatus;
	private Boolean isLastRequestSuccessful;
	private Date issueDateTime;
	private Long institutionId;
	private InstitutionDTO institution;

	private String dispStatus;
	private String dispLastFillDate;
	private String dispLastRefillSubmittedDate;
	private String dispNumberOfRefills;
	private String dispReleaseDateTime;
	private String dispIssueDateTime;
	private String dispExpirationCancelDate;
	private String dispModifiedDate;
	private String factilityName;
	private String dispRxNumber;
	//private int intRxNumber;
	
	private List <RxTrackingDTO> rxTrackingList;
	boolean isTracking;
	
	private boolean selected;
	
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	public Boolean getIsRefillable() {
		return isRefillable;
	}

	public void setIsRefillable(Boolean isRefillable) {
		this.isRefillable = isRefillable;
	}

	public String getPlacerOrderNumber() {
		return placerOrderNumber;
	}

	public void setPlacerOrderNumber(String placerOrderNumber) {
		this.placerOrderNumber = placerOrderNumber;
	}

	public Long getUserId() {
		return userId;
	}

	public void setUserId(Long userId) {
		this.userId = userId;
	}

	public UserProfileDTO getUserProfile() {
		return userProfile;
	}

	public void setUserProfile(UserProfileDTO userProfile) {
		this.userProfile = userProfile;
	}

	public String getIen() {
		return ien;
	}

	public void setIen(String ien) {
		this.ien = ien;
	}

	public String getProviderFirstName() {
		return providerFirstName;
	}

	public void setProviderFirstName(String providerFirstName) {
		this.providerFirstName = providerFirstName;
	}

	public String getProviderId() {
		return providerId;
	}

	public void setProviderId(String providerId) {
		this.providerId = providerId;
	}

	public Long getDivision() {
		return division;
	}

	public void setDivision(Long division) {
		this.division = division;
	}

	public Boolean getIsInactive() {
		return isInactive;
	}

	public void setIsInactive(Boolean isInactive) {
		this.isInactive = isInactive;
	}

	public String getSig() {
		return sig;
	}

	public void setSig(String sig) {
		this.sig = sig;
	}

	public String getMailWindow() {
		return mailWindow;
	}

	public void setMailWindow(String mailWindow) {
		this.mailWindow = mailWindow;
	}

	public Date getReleaseDateTime() {
		return releaseDateTime;
	}

	public void setReleaseDateTime(Date releaseDateTime) {
		this.releaseDateTime = releaseDateTime;
	}

	public Boolean getIsInvalidMhvStatus() {
		return isInvalidMhvStatus;
	}

	public void setIsInvalidMhvStatus(Boolean isInvalidMhvStatus) {
		this.isInvalidMhvStatus = isInvalidMhvStatus;
	}

	public String getPrescriptionNumber() {
		return prescriptionNumber;
	}

	public void setPrescriptionNumber(String prescriptionNumber) {
		this.prescriptionNumber = prescriptionNumber;
	}

	public Date getExpirationCancelDate() {
		return expirationCancelDate;
	}

	public void setExpirationCancelDate(Date expirationCancelDate) {
		this.expirationCancelDate = expirationCancelDate;
	}

	public String getProviderLastName() {
		return providerLastName;
	}

	public void setProviderLastName(String providerLastName) {
		this.providerLastName = providerLastName;
	}

	public BigDecimal getQuantity() {
		return quantity;
	}

	public void setQuantity(BigDecimal quantity) {
		this.quantity = quantity;
	}
	
	public Date getMhvStatusDate() {
		return mhvStatusDate;
	}

	public void setMhvStatusDate(Date mhvStatusDate) {
		this.mhvStatusDate = mhvStatusDate;
	}

	public Date getLastFillDate() {
		return lastFillDate;
	}

	public void setLastFillDate(Date lastFillDate) {
		this.lastFillDate = lastFillDate;
	}

	public String getRemarks() {
		return remarks;
	}

	public void setRemarks(String remarks) {
		this.remarks = remarks;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public Integer getDaysSupply() {
		return daysSupply;
	}

	public void setDaysSupply(Integer daysSupply) {
		this.daysSupply = daysSupply;
	}

	public Date getLastRefillSubmittedDate() {
		return lastRefillSubmittedDate;
	}

	public void setLastRefillSubmittedDate(Date lastRefillSubmittedDate) {
		this.lastRefillSubmittedDate = lastRefillSubmittedDate;
	}

	public String getDivisionName() {
		return divisionName;
	}

	public void setDivisionName(String divisionName) {
		this.divisionName = divisionName;
	}

	public Date getArchivedDate() {
		return archivedDate;
	}

	public void setArchivedDate(Date archivedDate) {
		this.archivedDate = archivedDate;
	}

	public String getDrugName() {
		return drugName;
	}

	public void setDrugName(String drugName) {
		this.drugName = drugName;
	}

	public Date getModifiedDate() {
		return modifiedDate;
	}

	public void setModifiedDate(Date modifiedDate) {
		this.modifiedDate = modifiedDate;
	}

	public Integer getNumberOfRefills() {
		return numberOfRefills;
	}

	public void setNumberOfRefills(Integer numberOfRefills) {
		this.numberOfRefills = numberOfRefills;
	}

	public Integer getMhvStatus() {
		return mhvStatus;
	}

	public void setMhvStatus(Integer mhvStatus) {
		this.mhvStatus = mhvStatus;
	}

	public Boolean getIsLastRequestSuccessful() {
		return isLastRequestSuccessful;
	}

	public void setIsLastRequestSuccessful(Boolean isLastRequestSuccessful) {
		this.isLastRequestSuccessful = isLastRequestSuccessful;
	}

	public Date getIssueDateTime() {
		return issueDateTime;
	}

	public void setIssueDateTime(Date issueDateTime) {
		this.issueDateTime = issueDateTime;
	}

	public Long getInstitutionId() {
		return institutionId;
	}

	public void setInstitutionId(Long institutionId) {
		this.institutionId = institutionId;
	}

	public InstitutionDTO getInstitution() {
		return institution;
	}

	public void setInstitution(InstitutionDTO institution) {
		this.institution = institution;
	}

	public String getFactilityName() {
		return factilityName;
	}

	public void setFactilityName(String factilityName) {
		this.factilityName = factilityName;
	}
	
	public String getDispStatus() {
		String status = getStatus();
		if (status == null || status.trim().length() == 0)
			dispStatus = "";

		if (PrescriptionStatusEnumeration.REFILLINPROCESS.getValue().equalsIgnoreCase(status)) {
			dispStatus = PrescriptionStatusEnumeration.REFILLINPROCESS.getDescription();		
		} else {
			dispStatus = status.substring(0, 1).toUpperCase() + status.substring(1);
		}

		return dispStatus;
	}
	
	public void setDispStatus(String dispStatus) {
		this.dispStatus = dispStatus;
	}
	
	public String getDispLastFillDate() {
		return dispDate(getLastFillDate());
	}

	public void setDispLastFillDate(String dispLastFillDate) {
		this.dispLastFillDate = dispLastFillDate;
	}

	public String getDispLastRefillSubmittedDate() {
		return dispDate(getLastRefillSubmittedDate());
	}

	public void setDispLastRefillSubmittedDate(String dispLastRefillSubmittedDate) {
		this.dispLastRefillSubmittedDate = dispLastRefillSubmittedDate;
	}

	public String getDispNumberOfRefills() {
		dispNumberOfRefills = (null != getNumberOfRefills()) ? String.valueOf(getNumberOfRefills()) : "";
		return dispNumberOfRefills;
	}

	public void setDispNumberOfRefills(String dispNumberOfRefills) {
		this.dispNumberOfRefills = dispNumberOfRefills;
	}
	
	public String getDispReleaseDateTime() {
		return dispDate(getReleaseDateTime());
	}
	
	public void setDispReleaseDateTime(String dispReleaseDateTime) {
		this.dispReleaseDateTime = dispReleaseDateTime;
	}

	public String getDispIssueDateTime() {
		return dispDate(getIssueDateTime());
	}

	public void setDispIssueDateTime(String dispIssueDateTime) {
		this.dispIssueDateTime = dispIssueDateTime;
	}

	public String getDispExpirationCancelDate() {
		return dispDate(getExpirationCancelDate());
	}

	public void setDispExpirationCancelDate(String dispExpirationCancelDate) {
		this.dispExpirationCancelDate = dispExpirationCancelDate;
	}
	
	public String getDispModifiedDate() {
        dispModifiedDate = (null != getModifiedDate()) ? new SimpleDateFormat("MM/dd/yyyy 'at' HHmm").format(getModifiedDate()) : "";
		return dispModifiedDate;
	}
	
	public void setDispModifiedDate(String dispModifiedDate) {
		this.dispModifiedDate = dispModifiedDate;
	}
	
	public String getDispRxNumber() {
		dispRxNumber = (null != getPrescriptionNumber()) ? "RX#: " + getPrescriptionNumber() : "";
		return dispRxNumber;
	}
	
	public void setDispRxNumber(String dispRxNumber) {
		this.dispRxNumber = dispRxNumber;
	}
	
	/*public int getIntRxNumber() {
		intRxNumber = (null != getPrescriptionNumber()) ? Integer.valueOf(getPrescriptionNumber()) : 0;
		return intRxNumber;
	}
	
	public void setIntRxNumber(int intRxNumber) {
		this.intRxNumber = intRxNumber;
	}*/
	
	public boolean isSelected() {
		return selected;
	}
	
	public void setSelected(boolean selected) {
		this.selected = selected;
	}

	public List <RxTrackingDTO> getRxTrackingList() {
		return rxTrackingList;
	}

	public void setRxTrackingList(List<RxTrackingDTO> rxTrackingList) {
		this.rxTrackingList = rxTrackingList;
	}

	private String dispDate(Date date) {
		return (null != date) ? WebUtility.dateToString(date, DISP_DATE_FORMAT) : "";
	}

	public boolean isTracking() {
		return isTracking;
	}

	public void setTracking(boolean isTracking) {
		this.isTracking = isTracking;
	}
}
