package gov.va.med.mhv.rxrefill.dto;

import java.util.Locale;

public class MyCompleteMedicationDTO  extends PrescriptionDTO implements Comparable<MyCompleteMedicationDTO>{

	private static final long serialVersionUID = 8300559065182083287L;
	
	private String category;
	private String source;
	private String strength;
	private String dosage;
	private String frequency;
	private String pharmacyPhone;
	private String reason;
	private String comments;
	
	public String getCategory() {
		return category;
	}
	public void setCategory(String category) {
		this.category = category;
	}
	public String getSource() {
		return source;
	}
	public void setSource(String source) {
		this.source = source;
	}
	public String getStrength() {
		return strength;
	}
	public void setStrength(String strength) {
		this.strength = strength;
	}
	public String getDosage() {
		return dosage;
	}
	public void setDosage(String dosage) {
		this.dosage = dosage;
	}
	public String getFrequency() {
		return frequency;
	}
	public void setFrequency(String frequency) {
		this.frequency = frequency;
	}
	public String getPharmacyPhone() {
		return pharmacyPhone;
	}
	public void setPharmacyPhone(String pharmacyPhone) {
		this.pharmacyPhone = pharmacyPhone;
	}
	public String getReason() {
		return reason;
	}
	public void setReason(String reason) {
		this.reason = reason;
	}
	public String getComments() {
		return comments;
	}
	public void setComments(String comments) {
		this.comments = comments;
	}
	@Override
	public int compareTo(MyCompleteMedicationDTO other) {
		int val=0;
		if(this != null &&
		   this.getStatus() != null && 
		   this.getDrugName() != null &&
		   other != null && 
		   other.getStatus() != null &&
		   other.getDrugName() != null){
		   val = getDispStatus().toUpperCase(Locale.ENGLISH).compareTo(other.getDispStatus().toUpperCase(Locale.ENGLISH));
		   if(val == 0){
			  val = getDrugName().toUpperCase(Locale.ENGLISH).compareTo(other.getDrugName().toUpperCase(Locale.ENGLISH));
		   }
		}
		return val;
	}
}
