package gov.va.med.mhv.mrp.webservice.impl;

import java.util.List;

import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

import gov.va.med.mhv.mrp.common.dto.MyGoalDTO;
import gov.va.med.mhv.mrp.common.dto.MyGoalTaskDTO;
import gov.va.med.mhv.mrp.common.dto.MyGoalTaskSearchDTO;
import gov.va.med.mhv.mrp.common.dto.MyGoalsExtensionDTO;
import gov.va.med.mhv.mrp.common.dto.MyTaskDTO;
import gov.va.med.mhv.mrp.common.dto.MyTaskSearchDTO;
import gov.va.med.mhv.mrp.service.MyGoalsService;
import gov.va.med.mhv.mrp.webservice.MyGoalsWebService;

public class MyGoalsWebServiceImpl implements MyGoalsWebService {
	private static Logger log = LogManager.getLogger(MyGoalsWebServiceImpl.class);

	@Autowired
	private MyGoalsService myGoalsService;

	@Override
	public List<MyGoalDTO> getMyGoalsForUser(Long userProfileId) {
		return myGoalsService.getMyGoalsForUser(userProfileId);
	}

	@Override
	public List<MyGoalDTO> getMyCompletedGoalsForUser(Long userProfileId) {
		return myGoalsService.getMyCompletedGoalsForUser(userProfileId);
	}
	
	@Override
	public MyGoalDTO getMyGoalById(Long userProfileId, Long goalId) {
		return myGoalsService.getMyGoalById(userProfileId, goalId);
	}

	@Override
	public MyGoalDTO getMyGoalByName(Long userProfileId, String goalName) {
		return myGoalsService.getMyGoalByName(userProfileId, goalName);
	}
	
	@Override
	public MyGoalDTO saveMyGoal(Long userProfileId, MyGoalDTO myGoalDTO) {
		return myGoalsService.saveMyGoal(myGoalDTO);
	}

	@Override
	public Response deleteMyGoal(Long userProfileId, Long goalId) {
		Boolean success = myGoalsService.deleteMyGoal(userProfileId, goalId);
		
		if (success) {
			return Response.ok().build();
		} else {
			return Response.status(Status.NO_CONTENT).build();
		}
	}
	
	@Override
	public List<MyTaskDTO> getMyGoalTasksForUser(MyGoalTaskSearchDTO myGoalTaskSearchDTO) {
		return myGoalsService.getMyGoalTasksForUser(myGoalTaskSearchDTO);
	}

	@Override
	public MyGoalsExtensionDTO getMyGoalsExtension(Long goalExtensionId) {
		return myGoalsService.getMyGoalsExtension(goalExtensionId);
	}
	
	@Override
	public MyGoalsExtensionDTO addMyGoalsExtension(Long goalId, MyGoalsExtensionDTO myGoalsExtensionDTO) {
		return myGoalsService.addMyGoalsExtension(goalId, myGoalsExtensionDTO);
	}

	@Override
	public Response deleteMyGoalsExtension(Long goalExtensionId) {
		Boolean success = myGoalsService.deleteMyGoalsExtension(goalExtensionId);
		
		if (success) {
			return Response.ok().build();
		} else {
			return Response.status(Status.NO_CONTENT).build();
		}
	}

	@Override
	public MyGoalTaskDTO addMyGoalTask(Long goalExtensionId, MyGoalTaskDTO myGoalTaskDTO) {
		return myGoalsService.addMyGoalTask(goalExtensionId, myGoalTaskDTO);
	}

	@Override
	public Response deleteMyGoalTask(Long taskId) {
		Boolean success = myGoalsService.deleteMyGoalTask(taskId);
		
		if (success) {
			return Response.ok().build();
		} else {
			return Response.status(Status.NO_CONTENT).build();
		}
	}

	@Override
	public List<MyTaskDTO> getMyGoalTasksByKeyword(MyGoalTaskSearchDTO myGoalTaskSearchDTO) {
		
		return myGoalsService.getMyGoalTasksByKeyword(myGoalTaskSearchDTO);
	}

	@Override
	public MyTaskSearchDTO getMyGoalsTaskByName(Long userProfileId, MyTaskSearchDTO myTaskSearchDTO) {
		log.debug("getMyGoalsTaskByName");
		return myGoalsService.findMyGoalForTask(userProfileId, myTaskSearchDTO);
	}

}
