package gov.va.med.mhv.mrp.web.validator;

import java.io.Serializable;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.primefaces.component.calendar.Calendar;

@FacesValidator(value = "taskEndDateValidator")
public class TaskEndDateValidator implements Validator, Serializable {
	private static final long serialVersionUID = 1L;
	private static Logger log = LogManager.getLogger(TaskEndDateValidator.class);
	
	@Override
	public void validate(FacesContext context, UIComponent component, Object submittedAndConvertedValue) throws ValidatorException {

		try {
			log.debug("validate");

			Integer completion = (Integer) submittedAndConvertedValue;

			log.debug("completion=" + completion);

			Calendar endDateCal = (Calendar) context.getViewRoot().findComponent("stepForm:endDate");
			
			log.debug("endDateCal=" + endDateCal);

			String endDate = (String) endDateCal.getSubmittedValue();
			
			log.debug("endDate=" + endDate);

			if (completion == 2 && (endDate == null || (endDate != null && endDate.isEmpty()))) {
				throw new ValidatorException(new FacesMessage("You must enter an End Date if My Task Completion is set to 'Has an End Date'"));
			}
		} catch (ValidatorException e) {
			log.debug(e);
			throw e;
		} catch (Exception e) {
			log.error(e);
		}
	}
	
}
