package gov.va.med.mhv.mrp.web.validator;

import java.io.Serializable;
import java.util.List;

import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ManagedProperty;
import javax.faces.bean.SessionScoped;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import gov.va.med.mhv.mrp.common.dto.MyGoalDTO;
import gov.va.med.mhv.mrp.web.bean.UserProfile;
import gov.va.med.mhv.mrp.webservice.MyGoalsWebService;

@ManagedBean
@SessionScoped
public class GoalNameValidator implements Validator, Serializable {
	private static final long serialVersionUID = 1L;
	private static Logger log = LogManager.getLogger(GoalNameValidator.class);

	@ManagedProperty("#{myGoalsWebServiceProxy}")
	private MyGoalsWebService myGoalsWebServiceProxy;

	@ManagedProperty("#{userProfile}")
	private UserProfile userProfile;

	@Override
	public void validate(FacesContext context, UIComponent component, Object submittedAndConvertedValue) throws ValidatorException {

		try {
			log.debug("validate");

			String name = (String) submittedAndConvertedValue;

			log.debug("name='" + name + "'");

			if (name == null || name.isEmpty()) {
				return; // Let required="true" or @NotNull handle it.
			}

			List<MyGoalDTO> list = myGoalsWebServiceProxy.getMyGoalsForUser(userProfile.getUserProfileId());
			
			if (list != null) {
				for (MyGoalDTO dto : list) {
					if (log.isDebugEnabled()) {
						log.debug("compare='" + dto.getGoalName().trim() + "' = '" + name.trim() + "'");
					}
					if (dto.getGoalName().trim().equalsIgnoreCase(name.trim()) && dto.getCompletedDate() == null) {
						throw new ValidatorException(new FacesMessage("You already have a Goal named '" + name + "'. Enter a new Goal name."));
					}
				}
			}

		} catch (ValidatorException e) {
			log.debug(e);
			throw e;
		} catch (Exception e) {
			log.error(e);
		}
	}

	public MyGoalsWebService getMyGoalsWebServiceProxy() {
		return myGoalsWebServiceProxy;
	}

	public void setMyGoalsWebServiceProxy(MyGoalsWebService myGoalsWebServiceProxy) {
		this.myGoalsWebServiceProxy = myGoalsWebServiceProxy;
	}

	public UserProfile getUserProfile() {
		return userProfile;
	}

	public void setUserProfile(UserProfile userProfile) {
		this.userProfile = userProfile;
	}
}
