package gov.va.med.mhv.mrp.web.util;

import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.portlet.PortletRequest;
import javax.ws.rs.core.Response;

import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.liferay.portal.model.User;
import com.liferay.portal.util.PortalUtil;

public class WebServiceClientUtil {
	private static Logger log = LogManager.getLogger(WebServiceClientUtil.class);

	private static final String ERR_PRCS_RQST = "Error Processing request";

	public static String formatErrorMessage(WebClient client, Response webserviceResponse) {
		StringBuffer sb = new StringBuffer();
		sb.append("Invalid Response to webservice call").append(",Webservice URL:").append(client.getCurrentURI())
				.append(",Status code:").append(webserviceResponse.getStatusInfo().getStatusCode()).append(",Reason:")
				.append(webserviceResponse.getStatusInfo().getReasonPhrase());
		return sb.toString();
	}

	public static void showErrorMessage() {
		FacesContext.getCurrentInstance().addMessage(null,
				new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
	}

	public static String getFirstName() {
		PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
		User user = null;
		try {
			user = PortalUtil.getUser(request);
		} catch (Exception e) {
			log.warn("unknown user");
		}

		return (user != null ? user.getFirstName() : "???");
	}

	public static String getLastName() {
		PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
		User user = null;
		try {
			user = PortalUtil.getUser(request);
		} catch (Exception e) {
			log.warn("unknown user");
		}

		return (user != null ? user.getLastName() : "???");
	}

	public static String getFullName() {
		return getFirstName() + " " + getLastName();
	}
}
