package gov.va.med.mhv.mrp.web.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import gov.va.med.mhv.mrp.enums.GoalPriorityTypeEnumeration;
import gov.va.med.mhv.mrp.web.util.MyGoalsCategoryCompare;
import gov.va.med.mhv.mrp.web.util.MyGoalsNameCompare;

public class MyGoals implements Serializable {
	private static final long serialVersionUID = 1L;
	private static Logger log = LogManager.getLogger(MyGoals.class);

	private List<MyGoal> goals = new ArrayList<MyGoal>();
	
	Map<String, List<MyGoal>> map = new LinkedHashMap<String, List<MyGoal>>();	

	public List<MyGoal> getGoalsMostImportant() {
		List<MyGoal> list = new ArrayList<MyGoal>();

		for (MyGoal goal : goals) {
			if (GoalPriorityTypeEnumeration.IMPORTANT.getCode().equals(goal.getPriorityType())) {
				list.add(goal);
			}
		}

		return list;
	}

	public List<MyGoal> getGoalsSecondMostImportant() {
		List<MyGoal> list = new ArrayList<MyGoal>();

		for (MyGoal goal : goals) {
			if (GoalPriorityTypeEnumeration.SECOND_IMPORTANT.getCode().equals(goal.getPriorityType())) {
				list.add(goal);
			}
		}

		return list;
	}

	public List<MyGoal> getOtherGoals() {
		List<MyGoal> list = new ArrayList<MyGoal>();

		for (MyGoal goal : goals) {
			if (GoalPriorityTypeEnumeration.OTHER.getCode().equals(goal.getPriorityType())) {
				list.add(goal);
			}
		}
		
		return list;
	}
	
	public Map<String, List<MyGoal>> getGoalsInCategory() {
		return map;
	}
	
	public void setFilters(List<MyGoal> goals) {
		this.goals = goals;
		
		Collections.sort(this.goals, new MyGoalsCategoryCompare());
		
		map = new LinkedHashMap<String, List<MyGoal>>();	
		
		log.debug("here");
		
		for (MyGoal goal : goals) {
			if (map.get(goal.getCategory()) == null) {
				List<MyGoal> list = new ArrayList<MyGoal>();
				list.add(goal);
				map.put(goal.getCategory(), list);	
			} else {
				List<MyGoal> list = map.get(goal.getCategory());
				list.add(goal);
			}			
		}
		
		for (Map.Entry<String, List<MyGoal>> entry : map.entrySet()) {
			Collections.sort(entry.getValue(), new MyGoalsNameCompare());
		}
		
		log.debug("map size=" + map.size());
	}

	public List<MyGoal> getGoals() {
		return goals;
	}

	public void setGoals(List<MyGoal> goals) {
		this.goals = goals;
	}

}
