package gov.va.med.mhv.mrp.web.model;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import gov.va.med.mhv.mrp.enums.GoalCompletionTypeEnumeration;
import gov.va.med.mhv.mrp.enums.GoalExtensionTypeEnumeration;
import gov.va.med.mhv.mrp.enums.GoalPriorityTypeEnumeration;

public class MyGoal implements Serializable {
	private static final long serialVersionUID = 1853691624859639192L;
	private static Logger log = LogManager.getLogger(MyGoal.class);

	private Long goalId;
	private String category;
	private Calendar completedDate;
	private Integer completionType;
	private String description;
	private Date endDate;
	private String goalName;
	private Integer oplock;
	private Integer priorityType;
	private Date startDate=GregorianCalendar.getInstance().getTime();
	private Integer status;
	private Integer statusMessage;
	private Long userProfileId;	
	private Boolean nameAlreadyInUse;

	private List<MyGoalsExtension> myGoalsExtensions = new ArrayList<MyGoalsExtension>();

	public boolean isCompletedToday() {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

		try {
			Date dt1 = sdf.parse(sdf.format(new Date()));
			Date dt2 = sdf.parse(sdf.format(completedDate.getTime()));

			Calendar cal1 = Calendar.getInstance();
			Calendar cal2 = Calendar.getInstance();
			cal1.setTime(dt1);
			cal2.setTime(dt2);
			
			log.debug("endDate=" + cal1.getTime() + ", today=" + cal2.getTime() + ", equals=" + cal1.compareTo(cal2));

			return cal1.compareTo(cal2) == 0;
		} catch (Exception e) {
			log.debug(e);
		}
		return false;
	}

	public List<MyGoalsExtension> getStrengths() {
		List<MyGoalsExtension> strengths = new ArrayList<MyGoalsExtension>();

		if (myGoalsExtensions != null) {
			for (MyGoalsExtension goalExt : myGoalsExtensions) {
				if (goalExt.isStrength()) {
					strengths.add(goalExt);
				}
			}
		}
		return strengths;
	}

	public List<MyGoalsExtension> getObstacles() {
		List<MyGoalsExtension> obstacles = new ArrayList<MyGoalsExtension>();

		if (myGoalsExtensions != null) {
			for (MyGoalsExtension goalExt : myGoalsExtensions) {
				if (goalExt.isObstacle()) {
					obstacles.add(goalExt);
				}
			}
		}
		
		return obstacles;
	}

	public List<MyGoalsExtension> getObstaclesWithoutTasks() {
		List<MyGoalsExtension> obstacles = new ArrayList<MyGoalsExtension>();

		if (myGoalsExtensions != null) {
			for (MyGoalsExtension goalExt : myGoalsExtensions) {
				if (goalExt.isObstacle() && goalExt.getTasks().isEmpty()) {
					obstacles.add(goalExt);
				}
			}
		}
		return obstacles;
	}
	
	public List<MyGoalsExtension> getObstaclesWithTasks() {
		List<MyGoalsExtension> obstacles = new ArrayList<MyGoalsExtension>();

		if (myGoalsExtensions != null) {
			for (MyGoalsExtension goalExt : myGoalsExtensions) {
				if (goalExt.isObstacle() && !goalExt.getTasks().isEmpty()) {
					obstacles.add(goalExt);
				}
			}
		}
		return obstacles;
	}
	
	public List<MyGoalsExtension> getObstaclesWithUnfinishedTasks() {
		List<MyGoalsExtension> obstacles = new ArrayList<MyGoalsExtension>();

		if (myGoalsExtensions != null) {
			for (MyGoalsExtension goalExt : myGoalsExtensions) {
				if (goalExt.isObstacle() && !goalExt.getTasks().isEmpty()) {
					boolean completed = true;
					for (MyGoalTask task : goalExt.getTasks()) {
						if (!task.getCompleted()) {
							completed = false;
							break;
						}
					}
					
					if (!completed) {
						obstacles.add(goalExt);
					}
				}
			}
		}
		return obstacles;
	}

	public List<MyGoalsExtension> getRewards() {
		List<MyGoalsExtension> rewards = new ArrayList<MyGoalsExtension>();

		if (myGoalsExtensions != null) {
			for (MyGoalsExtension goalExt : myGoalsExtensions) {
				if (goalExt.isReward()) {
					rewards.add(goalExt);
				}
			}
		}
		return rewards;
	}
	
	public MyGoalsExtension addGoalExtension(String description, GoalExtensionTypeEnumeration e) {
		MyGoalsExtension goalExt = new MyGoalsExtension();
		
		goalExt.setDescription(description);
		goalExt.setGoalExtensionType(e.getCode());
		goalExt.setGoalExtensionSeqNo(getNextSeqNo(e));
		myGoalsExtensions.add(goalExt);
		
		return goalExt;
	}

	private Integer getNextSeqNo(GoalExtensionTypeEnumeration e) {
		Integer seqNo = 0;

		if (myGoalsExtensions != null) {
			for (MyGoalsExtension goalExt : myGoalsExtensions) {
				seqNo = Math.max(seqNo, goalExt.getGoalExtensionSequenceNumber());
			}
		}
		
		return seqNo+1;
	}

	public String getPriorityTypeDescription() {
		return GoalPriorityTypeEnumeration.findByCode(priorityType).getDescription();
	}

	public String getCompletionTypeDescription() {
		return GoalCompletionTypeEnumeration.findByCode(completionType).getDescription();
	}

	public Long getGoalId() {
		return goalId;
	}

	public void setGoalId(Long goalId) {
		this.goalId = goalId;
	}

	public String getCategory() {
		return category;
	}

	public void setCategory(String category) {
		this.category = category;
	}

	public Calendar getCompletedDate() {
		return completedDate;
	}

	public void setCompletedDate(Calendar completedDate) {
		this.completedDate = completedDate;
	}

	public Integer getCompletionType() {
		return completionType;
	}

	public void setCompletionType(Integer completionType) {
		this.completionType = completionType;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public String getGoalName() {
		return goalName;
	}

	public void setGoalName(String goalName) {
		this.goalName = goalName;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public Integer getPriorityType() {
		return priorityType;
	}

	public void setPriorityType(Integer priorityType) {
		this.priorityType = priorityType;
	}

	public Date getStartDate() {
		return startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	public Integer getStatus() {
		return status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	public Integer getStatusMessage() {
		return statusMessage;
	}

	public void setStatusMessage(Integer statusMessage) {
		this.statusMessage = statusMessage;
	}

	public Long getUserProfileId() {
		return userProfileId;
	}

	public void setUserProfileId(Long userProfileId) {
		this.userProfileId = userProfileId;
	}

	public List<MyGoalsExtension> getMyGoalsExtensions() {
		return myGoalsExtensions;
	}

	public void setMyGoalsExtensions(List<MyGoalsExtension> myGoalsExtensions) {
		this.myGoalsExtensions = myGoalsExtensions;
	}

	public Boolean getNameAlreadyInUse() {
		return nameAlreadyInUse;
	}

	public void setNameAlreadyInUse(Boolean nameAlreadyInUse) {
		this.nameAlreadyInUse = nameAlreadyInUse;
	}

	@Override
	public String toString() {
		return "MyGoal [goalId=" + goalId + ", category=" + category + ", completedDate=" + completedDate + ", completionType=" + completionType + ", endDate="
				+ endDate + ", oplock=" + oplock + ", priorityType=" + priorityType + ", startDate=" + startDate + ", status=" + status + ", statusMessage="
				+ statusMessage + ", userProfileId=" + userProfileId + ", nameAlreadyInUse=" + nameAlreadyInUse + ", myGoalsExtensions=" + myGoalsExtensions
				+ "]";
	}

}
