package gov.va.med.mhv.mrp.web.converter;

import java.io.Serializable;

import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.mrp.common.dto.MyGoalsTaskActivitiesDTO;
import gov.va.med.mhv.mrp.web.model.MyGoalTaskActivity;

@Component
public class MyGoalTaskActivityDTOConverter implements Converter<MyGoalTaskActivity, MyGoalsTaskActivitiesDTO>, Serializable {
	private static final long serialVersionUID = 1L;

	@Override
	public MyGoalsTaskActivitiesDTO convert(MyGoalTaskActivity model) {
		MyGoalsTaskActivitiesDTO dto = new MyGoalsTaskActivitiesDTO();
		
		dto.setActivityDate(model.getActivityDate());
		dto.setOplock(model.getOplock());
		dto.setTaskActivityId(model.getTaskActivityId());
		dto.setTaskRepetitionCycleType(model.getTaskRepetitionCycleType());
		dto.setUpdatedTime(model.getUpdatedTime());
		
		return dto;
	}

}
