package gov.va.med.mhv.mrp.web.converter;

import java.io.Serializable;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.mrp.common.dto.MyGoalDTO;
import gov.va.med.mhv.mrp.common.dto.MyGoalsExtensionDTO;
import gov.va.med.mhv.mrp.web.model.MyGoal;
import gov.va.med.mhv.mrp.web.model.MyGoalsExtension;

@Component
public class MyGoalDTOConverter implements Converter<MyGoal, MyGoalDTO>, Serializable {
	private static final long serialVersionUID = 1L;
	
	@Autowired
	private MyGoalExtensionsDTOConverter myGoalExtensionsConverter;

	@Override
	public MyGoalDTO convert(MyGoal model) {
		MyGoalDTO dto = new MyGoalDTO();
		
		dto.setCategory(model.getCategory());
		dto.setCompletedDate(model.getCompletedDate());
		dto.setCompletionType(model.getCompletionType());
		dto.setDescription(model.getDescription());
		dto.setEndDate(model.getEndDate());
		dto.setGoalId(model.getGoalId());
		dto.setGoalName(model.getGoalName());
		dto.setOplock(model.getOplock());
		dto.setPriorityType(model.getPriorityType());
		dto.setStartDate(model.getStartDate());
		dto.setStatus(model.getStatus());
		dto.setStatusMessage(dto.getStatusMessage());
		dto.setUserProfileId(model.getUserProfileId());
		
		if (model.getMyGoalsExtensions() != null) {
			for (MyGoalsExtension ge : model.getMyGoalsExtensions()) {
				MyGoalsExtensionDTO geDTO = myGoalExtensionsConverter.convert(ge);
				dto.getMyGoalsExtensions().add(geDTO);
			}
		}
		
		return dto;
	}

}
