package gov.va.med.mhv.mrp.web.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import javax.annotation.PostConstruct;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ManagedProperty;
import javax.faces.bean.ViewScoped;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import gov.va.med.mhv.mrp.common.dto.MyGoalDTO;
import gov.va.med.mhv.mrp.web.bean.UserProfile;
import gov.va.med.mhv.mrp.web.converter.MyGoalListConverter;
import gov.va.med.mhv.mrp.web.model.MyGoal;
import gov.va.med.mhv.mrp.webservice.MyGoalsWebService;

@ManagedBean
@ViewScoped
public class ViewProgressController implements Serializable {
	private static final long serialVersionUID = 1L;
	private static Logger log = LogManager.getLogger(ViewProgressController.class);

	@ManagedProperty("#{myGoalsWebServiceProxy}")
	private transient MyGoalsWebService myGoalsWebServiceProxy;

	@ManagedProperty("#{myGoalListConverter}")
	private MyGoalListConverter myGoalListConverter;

	@ManagedProperty("#{userProfile}")
	private UserProfile userProfile;

	private Date startDate;

	private Date endDate;

	private Date maxDate;

	private List<MyGoal> goals;

	private List<MyGoal> selectedGoals = new ArrayList<MyGoal>();

	@PostConstruct
	public void init() {
		log.debug("@PostConstruct");

		log.debug("userProfileId=" + userProfile.getUserProfileId());

		if (userProfile.getUserProfileId() != null) {

			List<MyGoalDTO> dtoList = myGoalsWebServiceProxy.getMyGoalsForUser(userProfile.getUserProfileId());

			goals = myGoalListConverter.convert(dtoList);

			// default to all selected
			selectAll();
		}

		Calendar c = Calendar.getInstance();
		endDate = c.getTime();
		maxDate = c.getTime();

		c.add(Calendar.DAY_OF_MONTH, -90);
		startDate = c.getTime();
	}

	private void selectAll() {
		selectedGoals.clear();

		for (MyGoal myGoal : goals) {
			selectedGoals.add(myGoal);
		}
	}

	public String getNumberOfDays() {
		// it's only for display purposes
		// works like 99% of time - wont handle leap years, daylight savings
		// time, etc.
		// can't use Joda time and don't have Java 8
		Long numberOfDays = null;
		try {
			long difference = (endDate.getTime() - startDate.getTime()) / 86400000;
			numberOfDays = Math.abs(difference);
		} catch (Exception e) {
		}
		return numberOfDays != null ? numberOfDays.toString() : "";
	}

	public Date getStartDate() {
		return startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public Date getMaxDate() {
		return maxDate;
	}

	public void setMaxDate(Date maxDate) {
		this.maxDate = maxDate;
	}

	public List<MyGoal> getGoals() {
		return goals;
	}

	public List<MyGoal> getSelectedGoals() {
		return selectedGoals;
	}

	public void setSelectedGoals(List<MyGoal> selectedGoals) {
		this.selectedGoals = selectedGoals;
	}

	public void setMyGoalsWebServiceProxy(MyGoalsWebService myGoalsWebServiceProxy) {
		this.myGoalsWebServiceProxy = myGoalsWebServiceProxy;
	}

	public void setMyGoalListConverter(MyGoalListConverter myGoalListConverter) {
		this.myGoalListConverter = myGoalListConverter;
	}

	public void setUserProfile(UserProfile userProfile) {
		this.userProfile = userProfile;
	}
}
