package gov.va.med.mhv.mrp.web.controller;

import java.io.Serializable;
import java.util.Calendar;

import javax.annotation.PostConstruct;
import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ManagedProperty;
import javax.faces.bean.RequestScoped;
import javax.faces.bean.ViewScoped;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import gov.va.med.mhv.mrp.common.dto.MyGoalDTO;
import gov.va.med.mhv.mrp.enums.GoalCompletionTypeEnumeration;
import gov.va.med.mhv.mrp.enums.HourEnumeration;
import gov.va.med.mhv.mrp.enums.MinuteEnumeration;
import gov.va.med.mhv.mrp.web.bean.UserProfile;
import gov.va.med.mhv.mrp.web.converter.MyGoalConverter;
import gov.va.med.mhv.mrp.web.converter.MyGoalDTOConverter;
import gov.va.med.mhv.mrp.web.converter.MyGoalTaskDTOConverter;
import gov.va.med.mhv.mrp.web.model.MyGoal;
import gov.va.med.mhv.mrp.web.model.MyGoalTask;
import gov.va.med.mhv.mrp.web.model.MyGoalsExtension;
import gov.va.med.mhv.mrp.webservice.MyGoalsWebService;

@ManagedBean
@ViewScoped
public class TaskController implements Serializable {
	private static final long serialVersionUID = 1L;
	private static Logger log = LogManager.getLogger(TaskController.class);

	@ManagedProperty("#{myGoalsWebServiceProxy}")
	private MyGoalsWebService myGoalsWebServiceProxy;

	@ManagedProperty("#{myGoalConverter}")
	private MyGoalConverter myGoalConverter;

	@ManagedProperty("#{myGoalDTOConverter}")
	private MyGoalDTOConverter myGoalDTOConverter;

	@ManagedProperty("#{myGoalTaskDTOConverter}")
	private MyGoalTaskDTOConverter myGoalTaskDTOConverter;

	@ManagedProperty("#{userProfile}")
	private UserProfile userProfile;

//	@ManagedProperty("#{param.goalId}")
	private Long goalId;

//	@ManagedProperty("#{param.taskId}")
	private Long taskId;
	
	private boolean showConfirmation = false;

	private MyGoalTask myGoalTask = new MyGoalTask();

	private MyGoal goal = new MyGoal();

	public void init(ComponentSystemEvent event) {
		log.debug("init");

		FacesContext facesContext = FacesContext.getCurrentInstance();

		if (!facesContext.isPostback()) {
			log.debug("not postback");
			postConstruct();
		} else {
			log.debug("postback");
		}
	}
	
	//@PostConstruct
	private void postConstruct() {
		log.debug("@PostConstruct");
		log.debug(this);

		if (goalId != null && goalId != 0) {
			loadModel();
		} else {
			log.warn("Invalid parameters");
		}

	}

	private void loadModel() {
		MyGoalDTO dto = myGoalsWebServiceProxy.getMyGoalById(userProfile.getUserProfileId(), goalId);

		goal = myGoalConverter.convert(dto);

		for (MyGoalsExtension mge : goal.getObstacles()) {
			for (MyGoalTask task : mge.getTasks()) {
				if (task.getTaskId().equals(taskId)) {
					myGoalTask = task;
				}
			}
		}
		log.debug(this);
	}

	public void save() {
		
		log.debug("save");

		try {
			// check for no end date
			if (myGoalTask.getCompletionType().equals(GoalCompletionTypeEnumeration.NOENDDATE.getCode())) {
				myGoalTask.setEndDate(null);
			}

			MyGoalDTO myGoalDTO = myGoalDTOConverter.convert(goal);

			MyGoalDTO resultDTO = myGoalsWebServiceProxy.saveMyGoal(userProfile.getUserProfileId(), myGoalDTO);

			if (resultDTO == null) {
				log.warn("Save failed");
				FacesContext.getCurrentInstance().addMessage("", new FacesMessage(FacesMessage.SEVERITY_ERROR, "save failed", "save failed"));
			} else {
				log.debug("Save successful");
				loadModel();
				
				// if all tasks marked completed, then prompt user if they want to mark
				// the goal as completed
				if (goal.getObstaclesWithUnfinishedTasks().isEmpty()) {
					showConfirmation = true;
				}

			}

		} catch (Exception e) {
			log.debug(e);
		}
		
	}

	public String markCompleted(Boolean confirm) {

		log.debug("markCompleted, confirm=" + confirm);

		try {
			
			if (confirm) {
				MyGoalDTO myGoalDTO = myGoalDTOConverter.convert(goal);

				Calendar completedDate = Calendar.getInstance();
				myGoalDTO.setCompletedDate(completedDate);

				log.debug("saving");

				myGoalsWebServiceProxy.saveMyGoal(userProfile.getUserProfileId(), myGoalDTO);
				
				return "/views/completedgoals/summary";
				
			} else {
				showConfirmation = false;
			}

		} catch (Exception e) {
			log.debug(e);
		}

		return null;
	}

	public HourEnumeration[] getHours() {
		return HourEnumeration.values();
	}

	public MinuteEnumeration[] getMinutes() {
		return MinuteEnumeration.values();
	}

	public MyGoal getGoal() {
		return goal;
	}

	public boolean getShowConfirmation() {
		return showConfirmation;
	}

	public void setShowConfirmation(boolean showConfirmation) {
		this.showConfirmation = showConfirmation;
	}

	public void setGoal(MyGoal goal) {
		this.goal = goal;
	}

	public MyGoalTask getMyGoalTask() {
		return myGoalTask;
	}

	public void setMyGoalTask(MyGoalTask myGoalTask) {
		this.myGoalTask = myGoalTask;
	}

	public Long getGoalId() {
		return goalId;
	}

	public void setGoalId(Long goalId) {
		this.goalId = goalId;
	}

	public Long getTaskId() {
		return taskId;
	}

	public void setTaskId(Long taskId) {
		this.taskId = taskId;
	}

	public void setMyGoalsWebServiceProxy(MyGoalsWebService myGoalsWebServiceProxy) {
		this.myGoalsWebServiceProxy = myGoalsWebServiceProxy;
	}

	public void setMyGoalConverter(MyGoalConverter myGoalConverter) {
		this.myGoalConverter = myGoalConverter;
	}

	public void setMyGoalDTOConverter(MyGoalDTOConverter myGoalDTOConverter) {
		this.myGoalDTOConverter = myGoalDTOConverter;
	}

	public void setMyGoalTaskDTOConverter(MyGoalTaskDTOConverter myGoalTaskDTOConverter) {
		this.myGoalTaskDTOConverter = myGoalTaskDTOConverter;
	}

	public void setUserProfile(UserProfile userProfile) {
		this.userProfile = userProfile;
	}

	@Override
	public String toString() {
		return "TaskController [goalId=" + goalId + ", taskId=" + taskId + ", showConfirmation=" + showConfirmation + "]";
	}
}
