package gov.va.med.mhv.mrp.web.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.annotation.PostConstruct;
import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ManagedProperty;
import javax.faces.bean.RequestScoped;
import javax.faces.validator.ValidatorException;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import gov.va.med.mhv.mrp.common.dto.MyGoalDTO;
import gov.va.med.mhv.mrp.common.dto.MyGoalTaskDTO;
import gov.va.med.mhv.mrp.common.dto.MyGoalsExtensionDTO;
import gov.va.med.mhv.mrp.common.dto.MyGoalsTaskExtensionsDTO;
import gov.va.med.mhv.mrp.enums.GoalCompletionTypeEnumeration;
import gov.va.med.mhv.mrp.web.bean.UserProfile;
import gov.va.med.mhv.mrp.web.converter.MyGoalListConverter;
import gov.va.med.mhv.mrp.web.model.MyGoal;
import gov.va.med.mhv.mrp.web.model.MyGoals;
import gov.va.med.mhv.mrp.webservice.MyGoalsWebService;

@ManagedBean
@RequestScoped
public class CompletedGoalsController implements Serializable {
	private static final long serialVersionUID = 1L;
	private static Logger log = LogManager.getLogger(CompletedGoalsController.class);

	@ManagedProperty("#{myGoalsWebServiceProxy}")
	private MyGoalsWebService myGoalsWebServiceProxy;

	@ManagedProperty("#{myGoalListConverter}")
	private MyGoalListConverter myGoalListConverter;

	@ManagedProperty("#{userProfile}")
	private UserProfile userProfile;

	private MyGoals myGoals = new MyGoals();

	@PostConstruct
	public void init() {
		log.debug("PostConstruct");
		loadModel();
	}

	private void loadModel() {
		log.debug("loadModel, userProfileId=" + userProfile.getUserProfileId());

		if (userProfile.getUserProfileId() != null) {

			List<MyGoalDTO> dtoList = myGoalsWebServiceProxy.getMyCompletedGoalsForUser(userProfile.getUserProfileId());

			List<MyGoal> goalList = myGoalListConverter.convert(dtoList);

			myGoals.setGoals(goalList);

			List<MyGoalDTO> list = myGoalsWebServiceProxy.getMyGoalsForUser(userProfile.getUserProfileId());

			Set<String> goalNames = new HashSet<String>();
			
			if (list != null) {
				for (MyGoalDTO dto : list) {
					goalNames.add(dto.getGoalName().trim().toLowerCase());
				}
			}
			
			if (goalList != null) {
				for (MyGoal g : goalList) {
					if (goalNames.contains(g.getGoalName().trim().toLowerCase())) {
						g.setNameAlreadyInUse(true);
					}
				}
			}
			
		}
	}

	public String useGoalAgain(Long goalId) {
		String nextPage = null;

		log.debug("useGoalAgain");

		try {
			Long userProfileId = userProfile.getUserProfileId();
			MyGoalDTO dto = myGoalsWebServiceProxy.getMyGoalById(userProfileId, goalId);

			Date today = new Date();

			// reset id's to create new records
			dto.setGoalId(null);
			dto.setOplock(0);
			dto.setStartDate(today);
			dto.setCompletedDate(null);
			dto.setEndDate(null);
			dto.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());

			if (dto.getMyGoalsExtensions() != null) {
				for (MyGoalsExtensionDTO mge : dto.getMyGoalsExtensions()) {
					mge.setGoalExtensionId(null);
					mge.setOplock(0);
					if (mge.getMyGoalsTasks() != null) {
						for (MyGoalTaskDTO task : mge.getMyGoalsTasks()) {
							task.setTaskId(null);
							task.setOplock(0);
							task.setStartDate(today);
							task.setCompletedDate(null);
							task.setEndDate(null);
							task.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
							task.setMyGoalsTaskActivities(null);

							if (task.getMyGoalsTaskExtensions() != null) {
								for (MyGoalsTaskExtensionsDTO te : task.getMyGoalsTaskExtensions()) {
									te.setTaskExtensionId(null);
									te.setOplock(0);
								}
							}
						}
					}
				}
			}

			log.debug("Before save");
			MyGoalDTO copydto = myGoalsWebServiceProxy.saveMyGoal(userProfileId, dto);
			log.debug("After save");

			Long reuseGoalId = copydto.getGoalId();
			log.debug("new goalId=" + reuseGoalId);

			nextPage = "/views/trackgoals/viewgoal?faces-redirect=true&goalId=" + reuseGoalId;

		} catch (Exception e) {
			log.error(e);
		}

		return nextPage;
	}

	public MyGoals getMyGoals() {
		return myGoals;
	}

	public void setMyGoalsWebServiceProxy(MyGoalsWebService myGoalsWebServiceProxy) {
		this.myGoalsWebServiceProxy = myGoalsWebServiceProxy;
	}

	public void setMyGoalListConverter(MyGoalListConverter myGoalListConverter) {
		this.myGoalListConverter = myGoalListConverter;
	}

	public void setUserProfile(UserProfile userProfile) {
		this.userProfile = userProfile;
	}

}
