package gov.va.med.mhv.mrp.web.controller;

import java.io.Serializable;

import javax.faces.context.FacesContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;

import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;

import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.util.PortalUtil;

public abstract class AbstractController implements Serializable {

	private static final long serialVersionUID = -8611610134485398648L;
	private static Logger log = LogManager.getLogger(AbstractController.class);
	private String firstName;
	private String lastName;
	protected static final String DEFAULT_HOUR = "23";
	protected static final String DEFAULT_MINUTE = "59";
	protected static final String DEFAULT_DATETIME = "23:59";
	protected static final String HOUR_MINUTE = "HH:mm";
	protected static final String HOURS = "HH";
	protected static final String MINUTES = "mm";
	protected Boolean saveMessage = false;
	protected Boolean saveAndAddMessage = false;
	protected Boolean deleteMessage = false;
	protected String period;
	protected static final String YYYYMMDD_FORMAT = "yyyyMMdd";
	protected static final String YYYY_MM_DD_HHMMSS_FORMAT = "yyyy-MM-dd";
	protected static final String CHART_EXTENDER = "chartExtender";
	protected static final String DAYS = "dd";
	protected static final String MONTHS = "MM";
	protected static final String YEARS = "yyyy";
	protected static final String NO_DATA = "No data available";
	protected static final String ERR_PRCS_RQST = "Error Processing request";
	protected static final String CONTENT_TYPE = "application/json";

	@Value("${mrpEndpointUrl}")
	private String endpointUrl;

	// @Value("${usermgmtEndpointUrl}")
	private String userManagmentendpointUrl;

	@Value("${appContextroot}")
	private String appContextRoot;

	protected WebClient getWebClient() {
		log.debug("Health History endpoint##:");
		log.debug(endpointUrl);
		return WebClient.create(endpointUrl);
	}

	protected WebClient getUserManagmentWebClient() {
		log.debug("Usermanagement endpoint##:");
		log.debug(userManagmentendpointUrl);
		return WebClient.create(getUserManagmentendpointUrl());
	}

	// protected Gson getGsonTimeStamp() {
	// return new
	// GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss").serializeNulls().create();
	// }
	//
	// protected Gson getGson() {
	// return new
	// GsonBuilder().setDateFormat("yyyy-MM-dd").serializeNulls().create();
	// }
	//
	//
	// protected Gson getGsonWithoutDateFormat() {
	// return new GsonBuilder().serializeNulls().create();
	// }
	//
	// protected Gson getGsonTimeMilli() {
	// return new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSS
	// a").serializeNulls().create();
	// }
	//
	public String getAppContextRoot() {
		return appContextRoot;
	}

	public String getMhvContext() {
		String context = PropsUtil.get("mhv.context");
		return context;
	}

	public void findUser() {
		PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
		User user = null;
		try {
			user = PortalUtil.getUser(request);
		} catch (Exception e) {

		}
		if (user != null) {
			setFirstName(user.getFirstName());
			setLastName(user.getLastName());
		}
	}

	protected Long getUserProfileId() {
		Long userprofileId = null;
		PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
		PortletSession session = request.getPortletSession();
		Object profileId = session.getAttribute("LIFERAY_SHARED_userprofileid", PortletSession.APPLICATION_SCOPE);
		if (profileId != null) {
			userprofileId = (Long) profileId;
		}
		return userprofileId;
	}

	protected void resetMessages() {
		saveMessage = false;
		saveAndAddMessage = false;
		deleteMessage = false;
	}

	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public Boolean getSaveMessage() {
		return saveMessage;
	}

	public void setSaveMessage(Boolean saveMessage) {
		this.saveMessage = saveMessage;
	}

	public Boolean getSaveAndAddMessage() {
		return saveAndAddMessage;
	}

	public void setSaveAndAddMessage(Boolean saveAndAddMessage) {
		this.saveAndAddMessage = saveAndAddMessage;
	}

	public Boolean getDeleteMessage() {
		return deleteMessage;
	}

	public void setDeleteMessage(Boolean deleteMessage) {
		this.deleteMessage = deleteMessage;
	}

	public String getPeriod() {
		return period;
	}

	public void setPeriod(String period) {
		this.period = period;
	}

	public String getUserManagmentendpointUrl() {
		return userManagmentendpointUrl;
	}

	public void setUserManagmentendpointUrl(String userManagmentendpointUrl) {
		this.userManagmentendpointUrl = userManagmentendpointUrl;
	}
}
