package gov.va.med.mhv.mrp.web.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import javax.annotation.PostConstruct;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.SessionScoped;

import gov.va.med.mhv.mrp.enums.GoalCompletionTypeEnumeration;
import gov.va.med.mhv.mrp.enums.GoalExtensionTypeEnumeration;
import gov.va.med.mhv.mrp.enums.GoalPriorityTypeEnumeration;
import gov.va.med.mhv.mrp.enums.GoalTaskRepetitionCycleTypeEnum;
import gov.va.med.mhv.mrp.web.model.MyGoal;
import gov.va.med.mhv.mrp.web.model.MyGoalTask;
import gov.va.med.mhv.mrp.web.model.MyGoalsExtension;

@ManagedBean
@SessionScoped
public class GoalSamples implements Serializable {
	private static final long serialVersionUID = 1L;
	
	private List<MyGoal> samples = new ArrayList<MyGoal>();
	
	@PostConstruct
	private void init() {
		Calendar today = Calendar.getInstance();
		Calendar startDate = Calendar.getInstance();
		Calendar endDate = Calendar.getInstance();
		
		MyGoalsExtension ext = null;		
		MyGoalTask task = null;
		int taskNum = 0;

		// Lose 20 Pounds
		MyGoal myGoal = new MyGoal();		
		myGoal.setGoalName("Lose 20 Pounds");
		myGoal.setDescription("I now weigh 200 pounds. My first goal is to lose 20 pounds.");
		myGoal.setCategory("Health");	
		myGoal.setPriorityType(GoalPriorityTypeEnumeration.IMPORTANT.getCode());
		myGoal.setOplock(0);
		myGoal.setStartDate(today.getTime());
		
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 180);
		myGoal.setEndDate(endDate.getTime());
		myGoal.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		
		myGoal.addGoalExtension("I like riding my bike with friends and family.", GoalExtensionTypeEnumeration.STRENGTH);
		myGoal.addGoalExtension("I like trying new sports.", GoalExtensionTypeEnumeration.STRENGTH);
		myGoal.addGoalExtension("I want to be healthy.", GoalExtensionTypeEnumeration.STRENGTH);
		
		ext = myGoal.addGoalExtension("I eat when I am bored.", GoalExtensionTypeEnumeration.OBSTACLE);
		taskNum = 0;
		task = new MyGoalTask();
		task.setTaskName("Things to do when I am bored.");
		task.setDescription("I will make a list of things I can do when I am bored. This list will have activities like call a friend, do a puzzle, and take a walk.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.MONTHLY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
		task.setOplock(0);
		task.setStartDate(today.getTime());
		task.setGoalExtensionId(ext.getGoalExtensionId()); 
		taskNum++;  
		task.setTaskSequenceNumber(taskNum); 
		ext.getTasks().add(task);
		
		task = new MyGoalTask();
		task.setTaskName("How to use my list when I am bored.");
		task.setDescription("I will look at my list of activities when I am bored. I will choose an activity from my list to do instead of eating.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.DAILY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		startDate.add(Calendar.DAY_OF_MONTH, 1);
		task.setStartDate(startDate.getTime());
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);

		ext = myGoal.addGoalExtension("I never know if I am eating too much.", GoalExtensionTypeEnumeration.OBSTACLE);
		taskNum = 0;
		task = new MyGoalTask();
		task.setTaskName("Check my weight.");
		task.setDescription("I will weigh myself once a week and write it down on my calendar. I will also enter it into My HealtheVet.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.WEEKLY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
		task.setOplock(0);
		task.setStartDate(today.getTime());
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		
		task = new MyGoalTask();
		task.setTaskName("Eating Well.");
		task.setDescription("I will meet with a dietitian. I will learn what foods and how much I should be eating.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.NOREPEAT.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		startDate.add(Calendar.DAY_OF_MONTH, 14);
		task.setStartDate(startDate.getTime());
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 365+14);
		task.setEndDate(endDate.getTime());
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		
		task = new MyGoalTask();
		task.setTaskName("Food Journal.");
		task.setDescription("I will enter what I eat and drink in the My HealtheVet Food Journal every day.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.DAILY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
		task.setOplock(0);
		task.setStartDate(today.getTime());
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		
		ext = myGoal.addGoalExtension("I do not like to exercise.", GoalExtensionTypeEnumeration.OBSTACLE);
		taskNum = 0;
		task = new MyGoalTask();
		task.setTaskName("Move more every day.");
		task.setDescription("I will walk more to get to where I am going. I will use the stairs whenever I can. I will park farther from the store.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.DAILY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
		task.setOplock(0);
		task.setStartDate(today.getTime());
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		
		task = new MyGoalTask();
		task.setTaskName("Make exercise fun.");
		task.setDescription("I will make a list of physical activities I like to do. I can make exercise fun such as playing music or watching TV.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.MONTHLY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		startDate.add(Calendar.DAY_OF_MONTH, 1);
		task.setStartDate(startDate.getTime());
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		
		task = new MyGoalTask();
		task.setTaskName("Find an exercise buddy.");
		task.setDescription("I will ask someone to be my exercise buddy.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.NOREPEAT.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		startDate.add(Calendar.DAY_OF_MONTH, 7);
		task.setStartDate(startDate.getTime());
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 14);
		task.setEndDate(endDate.getTime());
		task.setGoalExtensionId(ext.getGoalExtensionId()); 
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		
		task = new MyGoalTask();
		task.setTaskName("Change my habits.");
		task.setDescription("I will set a time 5 days a week to do one of the activities on my list. I will do this activity for 15 minutes at first. I will increase it by 5 minutes each week.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.WEEKDAY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		startDate.add(Calendar.DAY_OF_MONTH, 7);
		task.setStartDate(startDate.getTime());
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		
		myGoal.addGoalExtension("Take a vacation.", GoalExtensionTypeEnumeration.REWARD);
		taskNum = 0;
		myGoal.addGoalExtension("Go golfing with a friend.", GoalExtensionTypeEnumeration.REWARD);
		taskNum = 0;
		samples.add(myGoal);

		// Be Debt Free
		myGoal = new MyGoal();		
		myGoal.setGoalName("Be Debt Free");
		myGoal.setDescription("I want to get out of debt.");
		myGoal.setCategory("Finance");	
		
		myGoal.setPriorityType(GoalPriorityTypeEnumeration.IMPORTANT.getCode());
		myGoal.setOplock(0);
		myGoal.setStartDate(today.getTime());
		
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 180);
		myGoal.setEndDate(endDate.getTime());
		myGoal.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		
		myGoal.addGoalExtension("I can follow a plan..", GoalExtensionTypeEnumeration.STRENGTH);
		myGoal.addGoalExtension("I have a steady income.", GoalExtensionTypeEnumeration.STRENGTH);
		myGoal.addGoalExtension("I have support from people that care about me.", GoalExtensionTypeEnumeration.STRENGTH);

		ext = myGoal.addGoalExtension("I do not know where my money goes each month. ", GoalExtensionTypeEnumeration.OBSTACLE);
		taskNum = 0;
		task = new MyGoalTask();
		task.setTaskName("Make a list of all my monthly bills.");
		task.setDescription("I will make a list of all of my monthly bills like rent, car payment, and credit cards. I need to know how much I owe each month.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.NOREPEAT.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		task.setStartDate(today.getTime());
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 14);
		task.setEndDate(endDate.getTime());
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++; 
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		
	    task = new MyGoalTask();
		task.setTaskName("Keep all receipts for 1 month.");
		task.setDescription("I will find a place like a folder or shoe box to keep my receipts for things I buy for 1 month. This includes anything that I paid cash for such as eating out for lunch.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.NOREPEAT.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		startDate.add(Calendar.DAY_OF_MONTH, 1);
		task.setStartDate(startDate.getTime());
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 14);
		task.setEndDate(endDate.getTime());
		task.setGoalExtensionId(ext.getGoalExtensionId()); 
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		
		task = new MyGoalTask();
		task.setTaskName("Group all of my receipts into 2 piles.");
		task.setDescription("I will make 2 piles for my receipts. The first pile will be receipts that were Needs such as groceries, electricity, and gas. The second pile will be receipts for other things like eating out, going to the movies, and buying coffee.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.NOREPEAT.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		startDate.add(Calendar.DAY_OF_MONTH, 1);
		task.setStartDate(startDate.getTime());
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 14);
		task.setEndDate(endDate.getTime());
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		
		task = new MyGoalTask();
		task.setTaskName("Pull together my receipts with my monthly bills such as rent, car payment from Task 1.");
		task.setDescription("I will make a list of all monthly receipts that I placed in my Needs pile. Add this list to my monthly bills list from Task 1. I can ask a friend, family member, or a VA Social Worker to help me.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.NOREPEAT.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		startDate.add(Calendar.DAY_OF_MONTH, 1);
		task.setStartDate(startDate.getTime());
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 14);
		task.setEndDate(endDate.getTime());
		task.setGoalExtensionId(ext.getGoalExtensionId()); 
		taskNum++; 
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		
		ext = myGoal.addGoalExtension("I do not know how to get rid of my debt.", GoalExtensionTypeEnumeration.OBSTACLE);
		taskNum = 0;
		
		task = new MyGoalTask();
		task.setTaskName("Get information on how to get rid of debt.");
		task.setDescription("I will find information about how to get rid of my debt from the Internet, local library, or a VA Social Worker. I will find information about making a monthly budget.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.DAILY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		task.setStartDate(today.getTime());
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 14);
		task.setEndDate(endDate.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++; 
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);

		task = new MyGoalTask();
		task.setTaskName("Make a plan to pay off credit cards and loans.");
		task.setDescription("I will make a list of all of my credit cards and loans that I pay each month. I will also list the amount owed, minimum payment, and interest rate for each of these bills.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.NOREPEAT.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		task.setStartDate(today.getTime());
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 14);
		task.setEndDate(endDate.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		
		task = new MyGoalTask();
		task.setTaskName("Find the bill that has the highest interest rate.");
		task.setDescription("I will look for the monthly bill with the highest interest rate. I will work toward paying off this bill first.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.NOREPEAT.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		task.setStartDate(today.getTime());
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 14);
		task.setEndDate(endDate.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);

		task = new MyGoalTask();
		task.setTaskName("Plan to pay off credit cards and loans.");
		task.setDescription("I will make a long term plan of how much I pay on each credit card and loan. I will pay more than the minimum payment each month. I will pay off my bills within the limits of my monthly income.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.NOREPEAT.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		task.setStartDate(today.getTime());
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 14);
		task.setEndDate(endDate.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		
		myGoal.addGoalExtension("Share my success with someone that is important to me.", GoalExtensionTypeEnumeration.REWARD);
		
		samples.add(myGoal);
		
		
		// Get a Job
		myGoal = new MyGoal();		
		myGoal.setGoalName("Get a Job");
		myGoal.setDescription("I want to get a job. I would like to have more money. It will also help me keep busy and feel better about myself.");
		myGoal.setCategory("Work");	
		myGoal.setPriorityType(GoalPriorityTypeEnumeration.IMPORTANT.getCode());
		myGoal.setOplock(0);
		myGoal.setStartDate(today.getTime());
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 180);
		//myGoal.setEndDate(endDate.getTime());
		myGoal.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());

		myGoal.addGoalExtension("I was in the military and received an honorable discharge.", GoalExtensionTypeEnumeration.STRENGTH);
		myGoal.addGoalExtension("I like to work hard.", GoalExtensionTypeEnumeration.STRENGTH);
		myGoal.addGoalExtension("I write well and can ask others to help me.", GoalExtensionTypeEnumeration.STRENGTH);
		myGoal.addGoalExtension("I am organized.", GoalExtensionTypeEnumeration.STRENGTH);
		myGoal.addGoalExtension("I can practice and learn new skills.", GoalExtensionTypeEnumeration.STRENGTH);	
		myGoal.addGoalExtension("I accept comments on how I perform.", GoalExtensionTypeEnumeration.STRENGTH);

		ext = myGoal.addGoalExtension("I do not know where to find a job. ", GoalExtensionTypeEnumeration.OBSTACLE);
		taskNum = 0;
		task = new MyGoalTask();
		task.setTaskName("Referral for work program at VA.");
		task.setDescription("I will check with a VA Social Worker for help. I will ask for a referral to a work program.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.NOREPEAT.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		task.setStartDate(today.getTime());
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 31);
		task.setEndDate(endDate.getTime());
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		
		task = new MyGoalTask();
		task.setTaskName("Get referral for work program through my State or County employment agency.");
		task.setDescription(" 	I will meet with someone from my State or County employment agency.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.NOREPEAT.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		startDate.add(Calendar.JUNE, 5);
		task.setStartDate(startDate.getTime());
		endDate = Calendar.getInstance();
		endDate.add(Calendar.JUNE, 8);
		task.setEndDate(endDate.getTime());
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		
		task = new MyGoalTask();
		task.setTaskName("Search job ads.");
		task.setDescription("I will search job ads in the local newspaper, online job sites, and employment agencies.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.DAILY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
		task.setOplock(0);
		task.setStartDate(today.getTime());
		//endDate = Calendar.getInstance();
		//endDate.add(Calendar.DAY_OF_MONTH, 31);
		//task.setEndDate(endDate.getTime());
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		
		ext = myGoal.addGoalExtension("I do not know what type of job I want. ", GoalExtensionTypeEnumeration.OBSTACLE);
		taskNum = 0;
		task = new MyGoalTask();
		task.setTaskName("Find out what I am good at doing.");
		task.setDescription("I will meet with someone at an employment agency or work program to find out what I am good at doing. I will find out what I am able to do.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.NOREPEAT.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		startDate.add(Calendar.DAY_OF_MONTH, 5);
		task.setStartDate(today.getTime());
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 31);
		task.setEndDate(endDate.getTime());
		task.setGoalExtensionId(ext.getGoalExtensionId()); 
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		
		task = new MyGoalTask();
		task.setTaskName("Match what I like and want with my new job.");
		task.setDescription("I will make a list of what I like to do and my skills. I will look at a list of open jobs and find ones that I am able to do or would like to try.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.NOREPEAT.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		startDate.add(Calendar.DAY_OF_MONTH, 1);
		task.setStartDate(today.getTime());
		//task.setEndDate(endDate.getTime());
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		
		ext = myGoal.addGoalExtension(" I do not know how to start looking for a job. ", GoalExtensionTypeEnumeration.OBSTACLE);
		taskNum = 0;
		task = new MyGoalTask();
		task.setTaskName("Ask for and fill out applications from job search.");
		task.setDescription("I will meet I will ask for a job application at places where I want to work. I will fill out the application in person. I will find jobs online too and submit my application online.with someone at an employment agency or work program to find out what I am good at doing. I will find out what I am able to do.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.TT.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		startDate.add(Calendar.DAY_OF_MONTH, 5);
		task.setStartDate(today.getTime());
		//endDate = Calendar.getInstance();
		//endDate.add(Calendar.DAY_OF_MONTH, 31);
		//task.setEndDate(endDate.getTime());
		task.setGoalExtensionId(ext.getGoalExtensionId());
		ext.getTasks().add(task);
		
		task = new MyGoalTask();
		task.setTaskName("Ask for help with applications.");
		task.setDescription("I will ask a friend or person at an employment agency to help me fill out my job application.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.WEEKLY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		startDate.add(Calendar.DAY_OF_MONTH, 8);
		task.setStartDate(today.getTime());
		//task.setEndDate(endDate.getTime());
		task.setGoalExtensionId(ext.getGoalExtensionId());
		ext.getTasks().add(task);

		task = new MyGoalTask();
		task.setTaskName("Practice interviews.");
		task.setDescription("I will practice doing an interview. I will practice with friends, family, or a person at an employment agency.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.WEEKLY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		startDate.add(Calendar.DAY_OF_MONTH, 8);
		task.setStartDate(today.getTime());
		//task.setEndDate(endDate.getTime());
		task.setGoalExtensionId(ext.getGoalExtensionId());
		ext.getTasks().add(task);
		
		task = new MyGoalTask();
		task.setTaskName("Keep a positive attitude.");
		task.setDescription("I know it takes time to find the right job. Each interview and application gets me closer to the right job for me. I will keep trying until I get hired.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.DAILY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
		task.setOplock(0);
		task.setStartDate(today.getTime());
		//task.setEndDate(endDate.getTime());
		task.setGoalExtensionId(ext.getGoalExtensionId());
		ext.getTasks().add(task);
		
		myGoal.addGoalExtension("Buy something I want with my first pay check.", GoalExtensionTypeEnumeration.REWARD);
		myGoal.addGoalExtension("Go out to lunch.", GoalExtensionTypeEnumeration.REWARD);
		myGoal.addGoalExtension("Take a friend out for coffee.", GoalExtensionTypeEnumeration.REWARD);
		myGoal.addGoalExtension("Go to the beach for the day.", GoalExtensionTypeEnumeration.REWARD);
		samples.add(myGoal);

		// Have More Fun
		myGoal = new MyGoal();		
		myGoal.setGoalName("Have More Fun");
		myGoal.setDescription("I want to have more things to do and be more social.");
		myGoal.setCategory("Leisure Activity");	
		myGoal.setPriorityType(GoalPriorityTypeEnumeration.OTHER.getCode());
		myGoal.setOplock(0);
		myGoal.setStartDate(today.getTime());
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 180);
		//myGoal.setEndDate(endDate.getTime());
		myGoal.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
		
		myGoal.addGoalExtension("I am loyal and care about others.", GoalExtensionTypeEnumeration.STRENGTH);
		myGoal.addGoalExtension("I am a good listener.", GoalExtensionTypeEnumeration.STRENGTH);
		myGoal.addGoalExtension("I used to do more things with friends.", GoalExtensionTypeEnumeration.STRENGTH);
		
		ext = myGoal.addGoalExtension(" I am nervous around others and don't know what to say.", GoalExtensionTypeEnumeration.OBSTACLE);
		taskNum = 0;
		task = new MyGoalTask();
		task.setTaskName("Become aware of when I am nervous.");
		task.setDescription("I will make a list of times when I am nervous around others. I will do this for seven days. Then I will list what I am thinking when I am nervous.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.DAILY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());
		endDate = Calendar.getInstance();
		endDate.add(Calendar.JUNE, 1);
		task.setEndDate(endDate.getTime());
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		
		task = new MyGoalTask();
		task.setTaskName("Change my thinking.");
		task.setDescription(" 	I will look at my list with a friend or someone from my health care team and write down a new thought I can have. This new thought will be something that can help me be calmer.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.DAILY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());
		endDate = Calendar.getInstance();
		endDate.add(Calendar.JUNE, 1);
		task.setEndDate(endDate.getTime());
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++; 
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);

		task = new MyGoalTask();
		task.setTaskName("Practice what to say.");
		task.setDescription("I will look at my list of times when I have been nervous in the past. I will share this list with a friend or someone from my health care team. I will practice what to say.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.MWF.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());
		//endDate = Calendar.getInstance();
		//endDate.add(Calendar.JUNE, 1);
		//task.setEndDate(endDate.getTime());
		task.setGoalExtensionId(ext.getGoalExtensionId()); 
		taskNum++; 
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		
		ext = myGoal.addGoalExtension(" I would rather be alone than with other people.", GoalExtensionTypeEnumeration.OBSTACLE);
		taskNum = 0;
		task = new MyGoalTask();
		task.setTaskName("Make a list of activities and places I like.");
		task.setDescription("I will list activities I might enjoy doing with others. This may include walking, bike riding, shopping, volunteer work, hobbies, going to the beach, mountains or the dog park.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.NOREPEAT.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());
		endDate = Calendar.getInstance();
		endDate.add(Calendar.JUNE, 1);
		task.setEndDate(endDate.getTime());
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		
		task = new MyGoalTask();
		task.setTaskName("Pick an activity to do with another person.");
		task.setDescription("I will use what I learned to ask someone to join me. I will ask someone to do one of the activities from my list with me. I will practice doing this several times and with different people.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.WEEKLY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());
		//endDate = Calendar.getInstance();
		//endDate.add(Calendar.JUNE, 1);
		//task.setEndDate(endDate.getTime());
		task.setGoalExtensionId(ext.getGoalExtensionId());
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		
		myGoal.addGoalExtension("Buy something that will help me with the activity I enjoy doing. For example, a new soccer ball.", GoalExtensionTypeEnumeration.REWARD);
		myGoal.addGoalExtension("Eat lunch at my favorite restaurant.", GoalExtensionTypeEnumeration.REWARD);
		samples.add(myGoal);
		
        // Find a Place to Live
		myGoal = new MyGoal();		
		myGoal.setGoalName("Find a Place to Live");
		myGoal.setDescription("I will move out of my current living situation and find another place to live.");
		myGoal.setCategory("Living Situation");	
		myGoal.setPriorityType(GoalPriorityTypeEnumeration.SECOND_IMPORTANT.getCode());
		myGoal.setOplock(0);
		myGoal.setStartDate(today.getTime());
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 180);
		//myGoal.setEndDate(endDate.getTime());
		myGoal.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
		
		myGoal.addGoalExtension("I am good at saving the money I earn.", GoalExtensionTypeEnumeration.STRENGTH);
		myGoal.addGoalExtension("I would be a good renter. I am quiet and tidy.", GoalExtensionTypeEnumeration.STRENGTH);
		myGoal.addGoalExtension("I am organized and determined.", GoalExtensionTypeEnumeration.STRENGTH);
		myGoal.addGoalExtension("I can use the computer", GoalExtensionTypeEnumeration.STRENGTH);
		myGoal.addGoalExtension("I know someone who can help me find a place to live.", GoalExtensionTypeEnumeration.STRENGTH);
		
		ext = myGoal.addGoalExtension("I am not sure how much I can afford.", GoalExtensionTypeEnumeration.OBSTACLE);
		taskNum = 0;
		task = new MyGoalTask();
		task.setTaskName("How much rent can I pay.");
		task.setDescription(" 	I will review my income and see how much money I have for rent");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.NOREPEAT.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());
		//endDate = Calendar.getInstance();
		//endDate.add(Calendar.JUNE, 1);
		//task.setEndDate(endDate.getTime());
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);		
		
		task = new MyGoalTask();
		task.setTaskName("What I want in a place to live.");
		task.setDescription(" 	I will make a list of what I need in the place I want to live. This list might include location, pets, no stairs, and near public bus lines.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.NOREPEAT.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());
		endDate = Calendar.getInstance();
		endDate.add(Calendar.JUNE, 1);
		task.setEndDate(endDate.getTime());
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++; 
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		
		task = new MyGoalTask();
		task.setTaskName("Rental Listings");
		task.setDescription(" 	I will get rental listings from newspapers, rental agencies, or online postings. I will get help from my local Veteran service officer or social services agency.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.DAILY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());
		endDate = Calendar.getInstance();
		endDate.add(Calendar.JUNE, 1);
		task.setEndDate(endDate.getTime());
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++; 
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);

		ext = myGoal.addGoalExtension("I am not sure how to get a place to live.", GoalExtensionTypeEnumeration.OBSTACLE);
		taskNum = 0;
		task = new MyGoalTask();
		task.setTaskName(" Search for a rental.");
		task.setDescription("I will call the number in the listings to set up visits.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.DAILY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());
		//endDate = Calendar.getInstance();
		//endDate.add(Calendar.JUNE, 1);
		//task.setEndDate(endDate.getTime());
		
		task.setGoalExtensionId(ext.getGoalExtensionId());
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		
		task = new MyGoalTask();
		task.setTaskName("Fill out rental applications.");
		task.setDescription(" 	I will search online or go to rental agencies to pick up rental applications for the place I want to live. I will submit applications online or in person.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.DAILY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());
		//endDate = Calendar.getInstance();
		//endDate.add(Calendar.JUNE, 1);
		//task.setEndDate(endDate.getTime());
		task.setGoalExtensionId(ext.getGoalExtensionId());
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		
		task = new MyGoalTask();
		task.setTaskName("Reference letter.");
		task.setDescription("I will ask for a reference letter from my employer, former roommate or neighbor.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.DAILY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());
		endDate = Calendar.getInstance();
		endDate.add(Calendar.JUNE, 1);
		task.setEndDate(endDate.getTime());
		task.setGoalExtensionId(ext.getGoalExtensionId()); 
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);

		ext = myGoal.addGoalExtension(" I may need help taking care of myself.", GoalExtensionTypeEnumeration.OBSTACLE);
		taskNum = 0;
		task = new MyGoalTask();
		task.setTaskName(" List things that I need to do each day.");
		task.setDescription("I will create a daily To Do List. My list will include things that I need help with such as showering or taking my medication.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.NOREPEAT.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());
		endDate = Calendar.getInstance();
		endDate.add(Calendar.JUNE, 1);
		task.setEndDate(endDate.getTime());
		task.setGoalExtensionId(ext.getGoalExtensionId()); 
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);		
		
		task = new MyGoalTask();
		task.setTaskName("Get help with my To Do List.");
		task.setDescription("I will make a plan on how to get each thing done on my list. I can ask someone to help me. I will write down my plan and work on each thing on my list.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.MWF.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());
		//endDate = Calendar.getInstance();
		//endDate.add(Calendar.JUNE, 1);
		//task.setEndDate(endDate.getTime());
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);

		ext = myGoal.addGoalExtension(" Fear of living alone.", GoalExtensionTypeEnumeration.OBSTACLE);
		taskNum = 0;
		task = new MyGoalTask();
		task.setTaskName("Talk with people I know who have lived alone.");
		task.setDescription("I will talk with people who live alone to find out how they do it.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.WEEKLY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());
		//endDate = Calendar.getInstance();
		//endDate.add(Calendar.JUNE, 1);
		//task.setEndDate(endDate.getTime());
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++; 
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);		
		
		task = new MyGoalTask();
		task.setTaskName("Remind myself of other things that I have done well on my own.");
		task.setDescription(" 	I will list things that I have done well in my life. When I am feeling alone I will read over my list.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.NOREPEAT.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());
		endDate = Calendar.getInstance();
		endDate.add(Calendar.JUNE, 1);
		task.setEndDate(endDate.getTime());
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		
		myGoal.addGoalExtension("Invite a friend over.", GoalExtensionTypeEnumeration.REWARD);
		myGoal.addGoalExtension("Get something for my new home.", GoalExtensionTypeEnumeration.REWARD);
		samples.add(myGoal);

		// Dating
		myGoal = new MyGoal();		
		myGoal.setGoalName("Dating");
		myGoal.setDescription("I want to be in a relationship. The first thing I need to do is start dating. I am lonely and would like to find someone to be with.");
		myGoal.setCategory("Relationships");

		myGoal.setPriorityType(GoalPriorityTypeEnumeration.OTHER.getCode());
		myGoal.setOplock(0);
		myGoal.setStartDate(today.getTime());
		
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 180);
		//myGoal.setEndDate(endDate.getTime());
		myGoal.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
		
		myGoal.addGoalExtension("I am loyal to people close to me.", GoalExtensionTypeEnumeration.STRENGTH);
		myGoal.addGoalExtension("I am kind to others.", GoalExtensionTypeEnumeration.STRENGTH);
		myGoal.addGoalExtension("I am a good listener.", GoalExtensionTypeEnumeration.STRENGTH);
		
		ext = myGoal.addGoalExtension("I worry what people think about me.", GoalExtensionTypeEnumeration.OBSTACLE);
		taskNum = 0;
		
		task = new MyGoalTask();
		task.setTaskName("Feeling relaxed around other people.");
		task.setDescription("I will practice breathing slowly and I will tell myself that other people like me.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.DAILY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);	
		
		task = new MyGoalTask();
		task.setTaskName("Help for feeling nervous around others.");
		task.setDescription("I will work with my health care team to help me feel less nervous around other people.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.WEEKLY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);	
		
		ext = myGoal.addGoalExtension(" I do not know where or how to meet someone to date.", GoalExtensionTypeEnumeration.OBSTACLE);
		taskNum = 0;
		
		task = new MyGoalTask();
		task.setTaskName("Make a list of things I like to do.");
		task.setDescription("I will write down things that I like to do. For example, I like to read, ride my bike, and cook. I will use this list to find people who like what I like.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.NOREPEAT.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 27);
		task.setEndDate(endDate.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId());
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);	
		
		task = new MyGoalTask();
		task.setTaskName("Find places to meet people who like what I like.");
		task.setDescription("I will use my list to find groups, clubs, or classes that focus on the things I like to do. For example: a book club, a bicycle riding group, or a local cooking class.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.WEEKLY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());
		task.setGoalExtensionId(ext.getGoalExtensionId());
		ext.getTasks().add(task);	
		
		task = new MyGoalTask();
		task.setTaskName("Check out some of the groups, clubs or classes I found.");
		task.setDescription("I will go to at least one meeting of each club, group, or class on my list. I will take someone along for support if I need them. Then I will decide which ones I want to join or sign up to attend regularly.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.WEEKLY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++; 
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);	

		ext = myGoal.addGoalExtension(" I do not know how to talk to someone I want to date.", GoalExtensionTypeEnumeration.OBSTACLE);
		taskNum = 0;
		
		task = new MyGoalTask();
		task.setTaskName("Take a class to help me talk to other people.");
		task.setDescription(" 	I will take a class on social skills at my local VA, if offered. If not offered at the VA, I will take a class at my local community college.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.TT.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 30);
		task.setEndDate(endDate.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId());
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);	
		
		task = new MyGoalTask();
		task.setTaskName("Practice talking with other people.");
		task.setDescription(" 	I will practice talking with people I know. I will start with people who are easiest to talk with, like my best friend. I will start to talk with people I do not know.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.WEEKLY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());
		task.setGoalExtensionId(ext.getGoalExtensionId());
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);	
		
		task = new MyGoalTask();
		task.setTaskName("Ask one or more people that interest me to an activity.");
		task.setDescription("I will ask one or more people that I like to attend an activity with me like a movie, shopping, or a sports game. This will help me practice asking people to do fun things together.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.OTHERWEEK.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);			
		
		task = new MyGoalTask();
		task.setTaskName("Date someone who interests me.");
		task.setDescription(" 	I will ask someone to have coffee with me. I understand some people may not say yes. I will keep asking until I find someone special.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.OTHERWEEK.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);	
		
		myGoal.addGoalExtension("Talk to my friend about my dating plans.", GoalExtensionTypeEnumeration.REWARD);
		samples.add(myGoal);

		//Go to School
		
		myGoal = new MyGoal();		
		myGoal.setGoalName("Go to School");
		myGoal.setDescription("I want to get a better job and need to get training. I want to go to college or a trade school.");
		myGoal.setCategory("Learning");
		
		myGoal.setPriorityType(GoalPriorityTypeEnumeration.SECOND_IMPORTANT.getCode());
		myGoal.setOplock(0);
		myGoal.setStartDate(today.getTime());
		
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 60);
		myGoal.setEndDate(endDate.getTime());
		myGoal.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		
		myGoal.addGoalExtension("I was a hard worker in the military.", GoalExtensionTypeEnumeration.STRENGTH);
		myGoal.addGoalExtension("I like to learn things.", GoalExtensionTypeEnumeration.STRENGTH);
		myGoal.addGoalExtension("I am a Veteran and I am eligible for benefits.", GoalExtensionTypeEnumeration.STRENGTH);
		myGoal.addGoalExtension("I can ask for help.", GoalExtensionTypeEnumeration.STRENGTH);
		myGoal.addGoalExtension("I am good at making decisions when I have all the information.", GoalExtensionTypeEnumeration.STRENGTH);

		ext = myGoal.addGoalExtension(" I do not know what school or program I want to attend. I do not know what is available or what I am eligible for.", GoalExtensionTypeEnumeration.OBSTACLE);
		taskNum = 0;
		
		task = new MyGoalTask();
		task.setTaskName("Research places to go to school.");
		task.setDescription("I will meet with a career counselor at my local community college or a Veteran's service officer at my local county or VA office. I will meet with a person at my local trade school. I can also search online for distance learning schools.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.WEEKLY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 15);
		task.setEndDate(endDate.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId());
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		
		task = new MyGoalTask();
		task.setTaskName("Meet with school counselors.");
		task.setDescription(" 	I will meet with a community college counselor. I will talk about my ideas and plans and see what they can offer to support me.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.OTHERWEEK.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 30);
		task.setEndDate(endDate.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId());
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);		
		
		task = new MyGoalTask();
		task.setTaskName("Make a list of schools I like.");
		task.setDescription("I will make a list of schools I like and how much they cost.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.WEEKLY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		startDate.add(Calendar.DAY_OF_MONTH, 30);
		task.setStartDate(startDate.getTime());
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 15);
		task.setEndDate(endDate.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);	
		
		ext = myGoal.addGoalExtension("I am not sure how I am going to pay for school.", GoalExtensionTypeEnumeration.OBSTACLE);
		taskNum = 0;
		
		task = new MyGoalTask();
		task.setTaskName("Search for VA Education Benefits, school financial aid, private loans, or payment plans.");
		task.setDescription("I will check with VA about education benefits for Veterans. I will meet with a school financial aid person and learn about aid, grants, and scholarships. I will ask about private loans and payment plans. I will check other sources of help, like the state vocational rehabilitation agency.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.WEEKLY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 45);
		task.setEndDate(endDate.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId());
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		
		task = new MyGoalTask();
		task.setTaskName("Match schools I like with how much they cost and my budget.");
		task.setDescription(" 	I will take the list of schools I like and see how much they cost. I will figure out how I can afford them with my budget.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.WEEKLY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		startDate.add(Calendar.DAY_OF_MONTH, 40);
		task.setStartDate(startDate.getTime());
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 40+15);
		task.setEndDate(endDate.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);		

		ext = myGoal.addGoalExtension("I have a learning or other disability and I am worried I will not be able to do the work or take a test. I am not sure if I can get around easily on campus.", GoalExtensionTypeEnumeration.OBSTACLE);
		taskNum = 0;
		
		task = new MyGoalTask();
		task.setTaskName("Meet with a person at my local school counseling center to ask about help for students with disabilities.");
		task.setDescription("I will check local schools and see what help they give to students with disabilities. I will meet with a person at my local school counseling center, or returning Veterans support office. I will find tutoring to help people like me.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.NOREPEAT.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		startDate.add(Calendar.DAY_OF_MONTH, 40);
		task.setStartDate(today.getTime());;
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 40+23);
		task.setEndDate(endDate.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId());
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		
		task = new MyGoalTask();
		task.setTaskName("Tour campus.");
		task.setDescription("I will tour the campus to see if there are areas where I may have problems getting around. I will make a plan of the easiest route to each class.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.NOREPEAT.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		startDate.add(Calendar.DAY_OF_MONTH, 40);
		task.setStartDate(today.getTime());
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 40+23);
		task.setEndDate(endDate.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId());
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		
		myGoal.addGoalExtension("Do something fun like go to the movies.", GoalExtensionTypeEnumeration.REWARD);
		myGoal.addGoalExtension("Share my decision with friends and people that are important to me.", GoalExtensionTypeEnumeration.REWARD);
		myGoal.addGoalExtension("Go out to dinner with family and friends to celebrate.", GoalExtensionTypeEnumeration.REWARD);
		
		samples.add(myGoal);

		// Join a Support Group
		
		myGoal = new MyGoal();		
		myGoal.setGoalName("Join a Support Group");
		myGoal.setDescription("I want to spend time with people with similar needs and interests. I will join a support or spirituality group that meets my needs. This can be a book club, garden club, or meditation group. This can be a 12-step group for alcohol or drug abuse or a grief support group.");
		myGoal.setCategory("Relationships");
		
		myGoal.setPriorityType(GoalPriorityTypeEnumeration.SECOND_IMPORTANT.getCode());
		myGoal.setOplock(0);
		myGoal.setStartDate(today.getTime());
		myGoal.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
		
		myGoal.addGoalExtension("I am friendly and enjoy people. I was active in other groups.", GoalExtensionTypeEnumeration.STRENGTH);
		myGoal.addGoalExtension("I am good at finding information. I do not give up.", GoalExtensionTypeEnumeration.STRENGTH);
		myGoal.addGoalExtension("I am able to make good choices about what is right for me.", GoalExtensionTypeEnumeration.STRENGTH);
		myGoal.addGoalExtension("I keep my promises. I honor my commitments.", GoalExtensionTypeEnumeration.STRENGTH);
		
		ext = myGoal.addGoalExtension(" I am afraid I will not fit in. People may not want me in their group.", GoalExtensionTypeEnumeration.OBSTACLE);
		taskNum = 0;
		task = new MyGoalTask();
		task.setTaskName("Make a list of all of the times I have been scared but still went through with my plan.");
		task.setDescription("I will make a list of the times that I have been scared and still went through with my plans. For example, completing basic training.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.NOREPEAT.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 2);
		task.setEndDate(endDate.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId());  taskNum++;  task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		task = new MyGoalTask();
		task.setTaskName("Make a list of things that people like about me.");
		task.setDescription(" 	I will make a list of things that I like about myself. I can ask for help making this list from a friend, family member, or my health care team.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.NOREPEAT.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 32);
		task.setEndDate(endDate.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId());
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		
		ext = myGoal.addGoalExtension("I do not know how to find a support group.", GoalExtensionTypeEnumeration.OBSTACLE);
		taskNum = 0;
		task = new MyGoalTask();
		task.setTaskName("Make a list of support groups that are available to me.");
		task.setDescription("I will look online, in my local newspaper, or community center to find support groups. I will also check with my local VA for help finding support groups.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.NOREPEAT.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 32);
		task.setEndDate(endDate.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		
		task = new MyGoalTask();
		task.setTaskName("Decide which support group to attend.");
		task.setDescription("I will pick a support group that seems most likely to meet my needs.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.DAILY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		startDate.add(Calendar.DAY_OF_MONTH, 32);
		task.setStartDate(startDate.getTime());
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 32 + 30);
		task.setEndDate(endDate.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId()); 
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		task.setTaskName("Find where the support group meets.");
		task.setDescription("I will find the location where the group meets. I will get directions from a friend, member of my health care team, or by looking on-line.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.NOREPEAT.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		startDate.add(Calendar.DAY_OF_MONTH, 60);
		task.setStartDate(startDate.getTime());
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 60+6);
		task.setEndDate(endDate.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId());
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		task = new MyGoalTask();
		task.setTaskName("I will find out when the group meets and schedule a time to attend.");
		task.setDescription(" 	I will call and ask when the group meets. I will choose a date and time to attend one of the meetings. I will put the meeting on my calendar. I will attend a support group meeting.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.DAILY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		startDate.add(Calendar.DAY_OF_MONTH, 60);
		task.setStartDate(startDate.getTime());
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 60 + 6);
		task.setEndDate(endDate.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		task = new MyGoalTask();
		task.setTaskName("Consider my experience with the support group.");
		task.setDescription(" 	I will make a list of 3 things I like and 3 things I do not like about this support group. I will make a decision about whether this group is right for me. If this group is not right for me, I will go back to Task #1 (Make a list of support groups that are available to me");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.DAILY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		startDate.add(Calendar.DAY_OF_MONTH, 60);
		task.setStartDate(startDate.getTime());
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 60 + 6);
		task.setEndDate(endDate.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId()); 
		taskNum++; 
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		
		
		ext = myGoal.addGoalExtension("I find excuses not to go places.", GoalExtensionTypeEnumeration.OBSTACLE);
		taskNum = 0;
		task = new MyGoalTask();
		task.setTaskName("Attend a group meeting.");
		task.setDescription("I will go to the group meeting in spite of my excuses. Sometimes it takes awhile before I like to do things, but later I am glad that I did.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.DAILY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		startDate.add(Calendar.DAY_OF_MONTH, 45);
		task.setEndDate(startDate.getTime());		
	
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		task = new MyGoalTask();
		task.setTaskName("Change my thinking.");
		task.setDescription(" 	I will make a list of what I can say to myself when I come up with an excuse not to go. I will overcome my excuses. I can ask people in my support group to help me change my thinking and encourage me to participate.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.TT.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		startDate.add(Calendar.DAY_OF_MONTH, 32);
		task.setStartDate(startDate.getTime());
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 32 + 30);
		task.setEndDate(endDate.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		task = new MyGoalTask();
		task.setTaskName("Be active in the support group.");
		task.setDescription("I will share experiences with my support group and show my care for them. I will make meetings important in my life. I will stay involved with my support group.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.WEEKLY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		startDate.add(Calendar.DAY_OF_MONTH, 60);
		task.setStartDate(startDate.getTime());
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		
		myGoal.addGoalExtension("Spend time with a person I like or my pet.", GoalExtensionTypeEnumeration.REWARD);
		myGoal.addGoalExtension("Invite a support group member to go with me to a ball game.", GoalExtensionTypeEnumeration.REWARD);
		myGoal.addGoalExtension("Have a movie and popcorn night.", GoalExtensionTypeEnumeration.REWARD);
		myGoal.addGoalExtension("Do something that I like to do such as go to the beach, eat at my favorite place, or take a walk.", GoalExtensionTypeEnumeration.REWARD);
			
		samples.add(myGoal);
		
		//Be Active in a Faith Group
		myGoal = new MyGoal();		
		myGoal.setGoalName("Be Active in a Faith Group");
		myGoal.setDescription("I want to spend time with others who have similar beliefs. I want to grow spiritually. I want to find a sense of peace and hope.");
		myGoal.setCategory("Spirituality");
		
		myGoal.setPriorityType(GoalPriorityTypeEnumeration.OTHER.getCode());
		myGoal.setOplock(0);
		myGoal.setStartDate(today.getTime());
		myGoal.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
		
		myGoal.addGoalExtension("I am friendly and enjoy people. I was active in other groups.", GoalExtensionTypeEnumeration.STRENGTH);
		myGoal.addGoalExtension("I am good at finding information. I do not give up.", GoalExtensionTypeEnumeration.STRENGTH);
		myGoal.addGoalExtension("I am able to make good choices about what is right for me.", GoalExtensionTypeEnumeration.STRENGTH);
		myGoal.addGoalExtension("I keep my promises. I honor my commitments.", GoalExtensionTypeEnumeration.STRENGTH);
		
		ext = myGoal.addGoalExtension("I am afraid I will not fit in. People may not want me in their group.", GoalExtensionTypeEnumeration.OBSTACLE);
		taskNum = 0;
		
		task = new MyGoalTask();
		task.setTaskName("Make a list of all of the times I have been scared but still went through with my plan.");
		task.setDescription("I will make a list of the times that I have been scared and still went through with my plans. For example, completing basic training.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.NOREPEAT.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());		
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 2);
		task.setEndDate(endDate.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		
		task = new MyGoalTask();
		task.setTaskName("Make a list of things that people like about me.");
		task.setDescription("I will make a list of things that I like about myself. I can ask for help making this list from a friend, family member, or my health care team.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.NOREPEAT.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());		
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 10);
		task.setEndDate(endDate.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId()); 
		taskNum++; 
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);

		
		ext = myGoal.addGoalExtension("I am afraid people from the faith group will judge me.", GoalExtensionTypeEnumeration.OBSTACLE);
		taskNum = 0;
		task = new MyGoalTask();
		task.setTaskName("Make a list of my past faith experiences that were good..");
		task.setDescription("I will make a list of good things from my past experiences with a faith group. For example, picnics, camps, and worship.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.NOREPEAT.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());		
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 2);
		task.setEndDate(endDate.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId());
		ext.getTasks().add(task);
		
		task = new MyGoalTask();
		task.setTaskName("Make a list of things that people like about me.");
		task.setDescription("I will make a list of things that I like about myself. I can ask for help making this list from a friend, family member, or my health care team.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.NOREPEAT.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());		
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 3);
		task.setEndDate(endDate.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId());
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		task.setTaskName("Make a list of what I have to offer to others in a faith group.");
		task.setDescription("I will make a list of things that I can contribute to a faith group. For example, my humor, volunteering, or willingness to help others. I enjoy singing with others, and I am pretty good at it.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.NOREPEAT.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());		
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 15);
		task.setEndDate(endDate.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++; 
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);

		ext = myGoal.addGoalExtension("I had a bad experience attending a faith group in the past.", GoalExtensionTypeEnumeration.OBSTACLE);
		taskNum = 0;
		
		task = new MyGoalTask();
		task.setTaskName("Write down the problem that I had with a faith group in my past.");
		task.setDescription("I will write down what happened, who was involved, and how I was hurt in the past.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.NOREPEAT.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		startDate.add(Calendar.DAY_OF_MONTH, 15);
		task.setStartDate(startDate.getTime());	
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 30);
		task.setEndDate(endDate.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		
		task = new MyGoalTask();
		task.setTaskName("Look at how much my story still upsets me.");
		task.setDescription(" 	I will think about my life and if and how my story is still important today. Is the hurt I experienced with my past faith group keeping me from what I want to do today? I can talk with a chaplain or a mental health care team member if I need help.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.WEEKLY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);	

		ext = myGoal.addGoalExtension("I do not know how to find a faith group.", GoalExtensionTypeEnumeration.OBSTACLE);
		taskNum = 0;
		task = new MyGoalTask();
		task.setTaskName("Make a list of faith groups that are available to me.");
		task.setDescription("I will look online, in my local newspaper, or community center to find what faith groups are available to me. I can also ask my local VA chaplain for help in finding a faith group that's good for me.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.DAILY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());		
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 15);
		task.setEndDate(endDate.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId()); 
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		
		task = new MyGoalTask();
		task.setTaskName("Decide which faith group to attend.");
		task.setDescription("I will choose a faith group from my list that meets my needs. Choices include Christian (many different groups), Jewish, Islamic, Buddhist, or another faith group. I can find information about faith groups by talking with a VA chaplain or a friend. I can also look online or in a library.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.NOREPEAT.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());		
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 15);
		task.setEndDate(endDate.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);	
		
		task = new MyGoalTask();
		task.setTaskName("Find where the faith group meets.");
		task.setDescription("I will find the location where the faith group meets. I can find this information by talking to a chaplain or a friend. I can also look in the newspaper, online, or in the phone book.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.NOREPEAT.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());		
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 15);
		task.setEndDate(endDate.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);			
		
		task = new MyGoalTask();
		task.setTaskName("Attend a local faith group meeting.");
		task.setDescription("I will call and ask when the group meets. I will choose a date and time to attend one of the meetings. I will put the meeting on my calendar. I will attend a faith group meeting.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.NOREPEAT.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());		
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 15);
		task.setEndDate(endDate.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId());
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);			
		
		task = new MyGoalTask();
		task.setTaskName("Consider my experience with the faith group.");
		task.setDescription("I will make a list of 3 things I like and 3 things I do not like about the faith group. I will make a decision about whether this faith group is right for me. If this group is not right for me, I will go back to Task #1 (Make a list of faith groups that are available to me).");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.NOREPEAT.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());		
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 15);
		task.setEndDate(endDate.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId()); 
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		
		ext = myGoal.addGoalExtension(" I find excuses not to go places.", GoalExtensionTypeEnumeration.OBSTACLE);
		taskNum = 0;
		task = new MyGoalTask();
		task.setTaskName("Attend a nearby faith group meeting.");
		task.setDescription(" 	I will go to a faith group meeting in spite of my excuses. Sometimes it takes awhile before I like to do things, but later I'm glad I did.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.WEEKLY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId());  taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);		
		
		task = new MyGoalTask();
		task.setTaskName("Change my thinking.");
		task.setDescription("I will make a list of what I can say to myself when I come up with an excuse not to go. I will overcome my excuses. I can ask people in my faith group to help me change my thinking and encourage me to participate.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.WEEKLY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);			
		
		task = new MyGoalTask();
		task.setTaskName("Be active in a faith group.");
		task.setDescription("I will share experiences with my faith group and show care for members. I will make meetings important in my life. I will stay involved with my faith group.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.WEEKLY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);			

		myGoal.addGoalExtension("Go out to eat with members of my faith group.", GoalExtensionTypeEnumeration.REWARD);
		myGoal.addGoalExtension("Take a 30-minute walk with a friend or pet.", GoalExtensionTypeEnumeration.REWARD);
		myGoal.addGoalExtension("Invite a faith group member to go with me to a ball game.", GoalExtensionTypeEnumeration.REWARD);
		myGoal.addGoalExtension("Have a movie and popcorn night.", GoalExtensionTypeEnumeration.REWARD);
			
		samples.add(myGoal);
		
		// Let Go of My Grudges, Anger and Resentment
		myGoal = new MyGoal();		
		myGoal.setGoalName("Let Go of My Grudges, Anger and Resentment");
		myGoal.setDescription("I will reduce my anger at people or things that irritate or frustrate me. I will become aware of my grudges, feelings of anger, and resentment. I will take steps to let go of them. I will change how I think about what makes me angry. I will reclaim a sense of peace.");
		myGoal.setCategory("Relationships");	
		
		myGoal.setPriorityType(GoalPriorityTypeEnumeration.OTHER.getCode());
		myGoal.setOplock(0);
		myGoal.setStartDate(today.getTime());
		myGoal.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
		
		myGoal.addGoalExtension("I am a strong person. I have the courage and ability to do this.", GoalExtensionTypeEnumeration.STRENGTH);
		myGoal.addGoalExtension("I will talk to my health care team if my anger or hurt is too deep.", GoalExtensionTypeEnumeration.STRENGTH);
		myGoal.addGoalExtension("I know how to get help. Many people want to help me.", GoalExtensionTypeEnumeration.STRENGTH);
		myGoal.addGoalExtension("I am ready to move on. My anger is the enemy of my peace.", GoalExtensionTypeEnumeration.STRENGTH);
		myGoal.addGoalExtension("I do not have to be an angry person.", GoalExtensionTypeEnumeration.STRENGTH);
		
		ext = myGoal.addGoalExtension("I do not know where to start. I am so overwhelmed.", GoalExtensionTypeEnumeration.OBSTACLE);
		taskNum = 0;
		
		task = new MyGoalTask();
		task.setTaskName("Decide if I can do this on my own.");
		task.setDescription("I will talk to a mental health care team member about my deep hurts. This Goal is NOT for helping me with very deep hurts. A deep hurt is violence of any type, including combat, attack (physical, mental, emotional, spiritual, sexual), or childhood abuse or neglect.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.NOREPEAT.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());		
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 15);
		task.setEndDate(endDate.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId());
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);	
		
		task = new MyGoalTask();
		task.setTaskName("Make a list of things that I am angry about.");
		task.setDescription("I will make a list of things I am angry about.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.NOREPEAT.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());		
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 15);
		task.setEndDate(endDate.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId());
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);				
		
		task = new MyGoalTask();
		task.setTaskName("Start \"letting go\" of these past hurts.");
		task.setDescription("When I think of a hurt, I will tell myself a positive thought. For example \"I can handle this.\" \"I will not let an old hurt ruin today.\" I will remember that my anger gets in the way of my peace.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.DAILY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId());
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);			
		
		task = new MyGoalTask();
		task.setTaskName("I will pick a hurt from my list, starting with the more simple hurts, and write down how that hurt has affected me.");
		task.setDescription("I will write down what happened to me. Who did what? Who said what? Why is this important to me? Why am I still angry about it today?");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.NOREPEAT.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());		
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 15);
		task.setEndDate(endDate.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId());
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);						
		
		task = new MyGoalTask();
		task.setTaskName("Re-read the story and write down 1 thing that I can change about what I am hurt and angry about.");
		task.setDescription("I will read my story each day for one week. I will choose one thing in my story each day that I can think differently about. I will write this down.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.DAILY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());		
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 30);
		task.setEndDate(endDate.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId());
		ext.getTasks().add(task);		
		
		task = new MyGoalTask();
		task.setTaskName("Rewrite my story.");
		task.setDescription("I will rewrite my story. I will rewrite how I would like the story to end and what I would do differently. If I need help I can take my story to my VA mental health care team, a VA chaplain, or a wise and trusted friend.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.DAILY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());		
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 30);
		task.setEndDate(endDate.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId());
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);		

		ext = myGoal.addGoalExtension("I am afraid of changing. Who am I without my anger?", GoalExtensionTypeEnumeration.OBSTACLE);
		taskNum = 0;
		task = new MyGoalTask();
		task.setTaskName("Imagine what I would be like without my anger. Imagine feeling peaceful.");
		task.setDescription("I will think about times I have been angry in the past week. I will imagine about how the situations would have been different if I did not get angry.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.DAILY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());		
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 15);
		task.setEndDate(endDate.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId());
		ext.getTasks().add(task);	
		
		task = new MyGoalTask();
		task.setTaskName("Talk to someone I trust and respect.");
		task.setDescription("I will think of people I can talk to about my anger. Examples include a spiritual leader, VA chaplain, a friend, or a family member not involved in the story. I will talk about my feelings with this person. I will ask them to help me imagine feeling peaceful.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.WEEKLY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId());
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		
		task = new MyGoalTask();
		task.setTaskName("Reconsider getting professional help. If this is more painful than I thought, I can ask for professional help.");
		task.setDescription("If I am still upset most of the time, I will get help. I will make an appointment to talk it over with a VA mental health care team member, VA chaplain, or mental health professional in my community.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.WEEKLY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId());
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);		

		ext = myGoal.addGoalExtension("I worry about appearing weak if I let go of my grudges, anger, resentments and forgive others.", GoalExtensionTypeEnumeration.OBSTACLE);
		taskNum = 0;
		task = new MyGoalTask();
		task.setTaskName("Decide if I am ready to forgive.");
		task.setDescription("I will understand that I don't have to forgive. If I am not ready to forgive I can come back later to work on this obstacle. Being angry is tiring and it takes away my strength. Letting go of my grudges, anger and resentment may lift some of my burdens. I would rather be free of these feelings and feel peaceful.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.DAILY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId());
		ext.getTasks().add(task);		
		
		task = new MyGoalTask();
		task.setTaskName("Write about a story when I made someone angry.");
		task.setDescription("My story will be about a time when someone became angry with me because of something I did or did not do. My story will answer: What did I do that hurt or angered them? What did I want and need? Did I intend to hurt them? Do I still need to make amends? Write about a time when someone forgave me. How did they do it? How did I feel? Did they seem weak or strong when they forgave me?");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.DAILY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());		
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 15);
		task.setEndDate(endDate.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);	
		
		task = new MyGoalTask();
		task.setTaskName("Talk to a person I trust and respect.");
		task.setDescription("I will discuss my story about when someone forgave me. I will talk about what is it like to be the angry person and what is it like to be the forgiving person. I will look for how people can move beyond their anger and reclaim peace. I will look for new ways to understand what happened.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.WEEKLY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());		
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 15);
		task.setEndDate(endDate.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId());  taskNum++;  task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);			
		
		task = new MyGoalTask();
		task.setTaskName("Write a letter to the person I hope to forgive.");
		task.setDescription(" 	I will write a letter to the person(s) about what happened and how I feel about it. I will write why this is important to me and what I want for the relationship. In the letter, I will offer forgiveness. I will not mail the letter.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.DAILY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());		
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 15);
		task.setEndDate(endDate.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId()); 
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		
		task = new MyGoalTask();
		task.setTaskName("Act on my decision to forgive.");
		task.setDescription("I will decide if I want to mail the letter. I can forgive the person without mailing the letter. I will stop avoiding the person and be kind to them. I will smile and talk nicely and expect nothing in return. I can forgive this person and reclaim my peace no matter how they act or respond.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.DAILY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.ENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());		
		endDate = Calendar.getInstance();
		endDate.add(Calendar.DAY_OF_MONTH, 15);
		task.setEndDate(endDate.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId());  
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);		
		
		task = new MyGoalTask();
		task.setTaskName("Ask for reading material about letting go of anger and practicing forgiveness.");
		task.setDescription(" 	If I am interested in reading about anger and forgiveness in holy scriptures, I can ask a VA chaplain or community clergy person from the faith group I prefer. If I am interested in reading about anger and forgiveness unrelated to religion, I can ask a chaplain or mental health provider for that too. I can look for resources in the library.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.OTHERWEEK.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId());  taskNum++;  task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);				
		task = new MyGoalTask();
		task.setTaskName("Cope with angry thoughts and feelings that may come back.");
		task.setDescription(" 	I will repeat the Tasks in this Goal again if I feel old grudges, resentments, and anger coming back. I will know this is part of the healing process.");
		task.setTaskRepetitionCycleType(GoalTaskRepetitionCycleTypeEnum.DAILY.getCode());
		task.setCompletionType(GoalCompletionTypeEnumeration.NOENDDATE.getCode());
		task.setOplock(0);
		startDate = Calendar.getInstance();
		task.setStartDate(today.getTime());		
		task.setGoalExtensionId(ext.getGoalExtensionId());
		taskNum++;  
		task.setTaskSequenceNumber(taskNum);
		ext.getTasks().add(task);
		
		myGoal.addGoalExtension("Take a vacation day.", GoalExtensionTypeEnumeration.REWARD);
		myGoal.addGoalExtension("Go fishing..", GoalExtensionTypeEnumeration.REWARD);
		myGoal.addGoalExtension("Buy music I have been wanting.", GoalExtensionTypeEnumeration.REWARD);
		myGoal.addGoalExtension("Spend a day at the beach.", GoalExtensionTypeEnumeration.REWARD);
		
		samples.add(myGoal);
}

	public List<MyGoal> getSamples() {
		return samples;
	}
	
}
