package gov.va.med.mhv.mrp.service.converter;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.mrp.common.dto.MyGoalDTO;
import gov.va.med.mhv.mrp.common.dto.MyGoalsExtensionDTO;
import gov.va.med.mhv.mrp.data.model.MyGoals;
import gov.va.med.mhv.mrp.data.model.MyGoalsExtensions;

@Component
public class MyGoalDTOConverter implements Converter<MyGoalDTO, MyGoals> {

	@Autowired
	private MyGoalExtensionsDTOConverter myGoalExtensionsDTOConverter;

	@Override
	public MyGoals convert(MyGoalDTO dto) {
		MyGoals e = new MyGoals();

		e.setCategory(dto.getCategory());
		e.setCompletedDate(dto.getCompletedDate());
		e.setCompletionType(dto.getCompletionType());
		e.setDescription(dto.getDescription());
		e.setEndDate(dto.getEndDate());
		e.setGoalId(dto.getGoalId());
		e.setGoalName(dto.getGoalName());
		e.setOplock(dto.getOplock());
		e.setPriorityType(dto.getPriorityType());
		e.setStartDate(dto.getStartDate());
		e.setStatus(dto.getStatus());
		e.setStatusMessage(e.getStatusMessage());
		e.setUserProfileId(dto.getUserProfileId());

		if (dto.getMyGoalsExtensions() != null) {
			for (MyGoalsExtensionDTO geDTO : dto.getMyGoalsExtensions()) {
				MyGoalsExtensions ge = myGoalExtensionsDTOConverter.convert(geDTO);
				e.addMyGoalsExtension(ge);
			}
		}

		return e;
	}
}
