package gov.va.med.mhv.mrp.service.converter;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.mrp.common.dto.MyGoalDTO;
import gov.va.med.mhv.mrp.common.dto.MyGoalsExtensionDTO;
import gov.va.med.mhv.mrp.data.model.MyGoals;
import gov.va.med.mhv.mrp.data.model.MyGoalsExtensions;

@Component
public class MyGoalConverter implements Converter<MyGoals, MyGoalDTO> {
	
	@Autowired
	private MyGoalExtensionsConverter myGoalExtensionsConverter;

	@Override
	public MyGoalDTO convert(MyGoals e) {
		MyGoalDTO dto = new MyGoalDTO();
		
		dto.setCategory(e.getCategory());
		dto.setCompletedDate(e.getCompletedDate());
		dto.setCompletionType(e.getCompletionType());
		dto.setDescription(e.getDescription());
		dto.setEndDate(e.getEndDate());
		dto.setGoalId(e.getGoalId());
		dto.setGoalName(e.getGoalName());
		dto.setOplock(e.getOplock());
		dto.setPriorityType(e.getPriorityType());
		dto.setStartDate(e.getStartDate());
		dto.setStatus(e.getStatus());
		dto.setStatusMessage(dto.getStatusMessage());
		dto.setUserProfileId(e.getUserProfileId());
		
		if (e.getMyGoalsExtensions() != null) {
			for (MyGoalsExtensions ge : e.getMyGoalsExtensions()) {
				MyGoalsExtensionDTO geDTO = myGoalExtensionsConverter.convert(ge);
				dto.getMyGoalsExtensions().add(geDTO);
			}
		}
		
		return dto;
	}
}
