package gov.va.med.mhv.mrp.data.model;

import java.io.Serializable;
import javax.persistence.*;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

@Entity
@Table(name="MYGOALS_TASKS")
@NamedQuery(name="MyGoalsTasks.findAll", query="SELECT m FROM MyGoalsTasks m")
public class MyGoalsTasks implements Serializable {
	private static final long serialVersionUID = 1L;

	@Id
	@GeneratedValue(strategy=GenerationType.AUTO)
	@Column(name="TASK_ID")
	private Long taskId;

	@Temporal(TemporalType.TIMESTAMP)
	@Column(name="COMPLETED_DATE")
	private Calendar completedDate;

	@Column(name="COMPLETION_TYPE")
	private Integer completionType;

	private String description;

	@Temporal(TemporalType.TIMESTAMP)
	@Column(name="END_DATE")
	private Date endDate;

	@Temporal(TemporalType.TIMESTAMP)
	@Column(name="END_TIME")
	private Calendar endTime;
	
	@Version
	private Integer oplock;

	@Temporal(TemporalType.TIMESTAMP)
	@Column(name="START_DATE")
	private Date startDate;

	@Temporal(TemporalType.TIMESTAMP)
	@Column(name="START_TIME")
	private Calendar startTime;
	
	@Column(name="STATUS")
	private Integer status = 0;

	@Column(name="TASK_NAME")
	private String taskName;

	@Column(name="TASK_REPETITION_CYCLE_TYPE")
	private Integer taskRepetitionCycleType;

	@Column(name="TASK_SEQUENCE_NUMBER")
	private Integer taskSequenceNumber;

	//bi-directional many-to-one association to MyGoalsExtensions
	@ManyToOne
	@JoinColumn(name="GOAL_EXTENSION_ID")
	private MyGoalsExtensions myGoalsExtension;

	//bi-directional many-to-one association to MyGoalsTaskActivities
	@OneToMany(mappedBy="myGoalsTask", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
	private List<MyGoalsTaskActivities> myGoalsTaskActivities = new ArrayList<MyGoalsTaskActivities>();

	//bi-directional many-to-one association to MyGoalsTaskExtensions
	@OneToMany(mappedBy="myGoalsTask", cascade={CascadeType.ALL}, fetch=FetchType.EAGER, orphanRemoval=true)
	private List<MyGoalsTaskExtensions> myGoalsTaskExtensions = new ArrayList<MyGoalsTaskExtensions>();

	public MyGoalsTasks() {
	}

	public Long getTaskId() {
		return this.taskId;
	}

	public void setTaskId(Long taskId) {
		this.taskId = taskId;
	}

	public Calendar getCompletedDate() {
		return this.completedDate;
	}

	public void setCompletedDate(Calendar completedDate) {
		this.completedDate = completedDate;
	}

	public Integer getCompletionType() {
		return this.completionType;
	}

	public void setCompletionType(Integer completionType) {
		this.completionType = completionType;
	}

	public String getDescription() {
		return this.description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Date getEndDate() {
		return this.endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public Calendar getEndTime() {
		return this.endTime;
	}

	public void setEndTime(Calendar endTime) {
		this.endTime = endTime;
	}

	public Integer getOplock() {
		return this.oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public Date getStartDate() {
		return this.startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	public Calendar getStartTime() {
		return this.startTime;
	}

	public void setStartTime(Calendar startTime) {
		this.startTime = startTime;
	}

	public Integer getStatus() {
		return this.status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	public String getTaskName() {
		return this.taskName;
	}

	public void setTaskName(String taskName) {
		this.taskName = taskName;
	}

	public Integer getTaskRepetitionCycleType() {
		return this.taskRepetitionCycleType;
	}

	public void setTaskRepetitionCycleType(Integer taskRepetitionCycleType) {
		this.taskRepetitionCycleType = taskRepetitionCycleType;
	}

	public Integer getTaskSequenceNumber() {
		return this.taskSequenceNumber;
	}

	public void setTaskSequenceNumber(Integer taskSequenceNumber) {
		this.taskSequenceNumber = taskSequenceNumber;
	}

	public MyGoalsExtensions getMyGoalsExtension() {
		return this.myGoalsExtension;
	}

	public void setMyGoalsExtension(MyGoalsExtensions myGoalsExtension) {
		this.myGoalsExtension = myGoalsExtension;
	}

	public List<MyGoalsTaskActivities> getMyGoalsTaskActivities() {
		return this.myGoalsTaskActivities;
	}

	public void setMyGoalsTaskActivities(List<MyGoalsTaskActivities> myGoalsTaskActivities) {
		this.myGoalsTaskActivities = myGoalsTaskActivities;
	}

	public MyGoalsTaskActivities addMyGoalsTaskActivity(MyGoalsTaskActivities myGoalsTaskActivity) {
		getMyGoalsTaskActivities().add(myGoalsTaskActivity);
		myGoalsTaskActivity.setMyGoalsTask(this);

		return myGoalsTaskActivity;
	}

	public MyGoalsTaskActivities removeMyGoalsTaskActivity(MyGoalsTaskActivities myGoalsTaskActivity) {
		getMyGoalsTaskActivities().remove(myGoalsTaskActivity);
		myGoalsTaskActivity.setMyGoalsTask(null);

		return myGoalsTaskActivity;
	}

	public List<MyGoalsTaskExtensions> getMyGoalsTaskExtensions() {
		return this.myGoalsTaskExtensions;
	}

	public void setMyGoalsTaskExtensions(List<MyGoalsTaskExtensions> myGoalsTaskExtensions) {
		this.myGoalsTaskExtensions = myGoalsTaskExtensions;
	}

	public MyGoalsTaskExtensions addMyGoalsTaskExtension(MyGoalsTaskExtensions myGoalsTaskExtension) {
		getMyGoalsTaskExtensions().add(myGoalsTaskExtension);
		myGoalsTaskExtension.setMyGoalsTask(this);

		return myGoalsTaskExtension;
	}

	public MyGoalsTaskExtensions removeMyGoalsTaskExtension(MyGoalsTaskExtensions myGoalsTaskExtension) {
		getMyGoalsTaskExtensions().remove(myGoalsTaskExtension);
		myGoalsTaskExtension.setMyGoalsTask(null);

		return myGoalsTaskExtension;
	}

	@Override
	public String toString() {
		String startTimeStr = (startTime != null ? (startTime.get(Calendar.HOUR_OF_DAY) + ":" + startTime.get(Calendar.MINUTE)) : "null");
		String endTimeStr = (endTime != null ? endTime.get(Calendar.HOUR_OF_DAY) + ":" + endTime.get(Calendar.MINUTE) : "null");
		
		return "MyGoalsTasks [taskId=" + taskId + ", completedDate=" + completedDate + ", completionType=" + completionType + ", description=" + description
				+ ", endDate=" + endDate + ", endTime=" + endTimeStr + ", oplock=" + oplock + ", startDate=" + startDate + ", startTime=" + startTimeStr + ", status="
				+ status + ", taskName=" + taskName + ", taskRepetitionCycleType=" + taskRepetitionCycleType + ", taskSequenceNumber=" + taskSequenceNumber
				+ ", myGoalsExtension=" + myGoalsExtension + ", myGoalsTaskActivities=" + myGoalsTaskActivities + ", myGoalsTaskExtensions="
				+ myGoalsTaskExtensions + "]";
	}

	
}