package gov.va.med.mhv.liferay.service.persistence;

import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsKeys;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;

import gov.va.med.mhv.liferay.NoSuchLiferayServiceException;
import gov.va.med.mhv.liferay.model.LiferayService;
import gov.va.med.mhv.liferay.model.impl.LiferayServiceImpl;
import gov.va.med.mhv.liferay.model.impl.LiferayServiceModelImpl;
import gov.va.med.mhv.liferay.service.persistence.LiferayServicePersistence;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/**
 * The persistence implementation for the liferay service service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see LiferayServicePersistence
 * @see LiferayServiceUtil
 * @generated
 */
public class LiferayServicePersistenceImpl extends BasePersistenceImpl<LiferayService>
    implements LiferayServicePersistence {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. Always use {@link LiferayServiceUtil} to access the liferay service persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */
    public static final String FINDER_CLASS_NAME_ENTITY = LiferayServiceImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(LiferayServiceModelImpl.ENTITY_CACHE_ENABLED,
            LiferayServiceModelImpl.FINDER_CACHE_ENABLED,
            LiferayServiceImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION,
            "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(LiferayServiceModelImpl.ENTITY_CACHE_ENABLED,
            LiferayServiceModelImpl.FINDER_CACHE_ENABLED,
            LiferayServiceImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(LiferayServiceModelImpl.ENTITY_CACHE_ENABLED,
            LiferayServiceModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_UUID = new FinderPath(LiferayServiceModelImpl.ENTITY_CACHE_ENABLED,
            LiferayServiceModelImpl.FINDER_CACHE_ENABLED,
            LiferayServiceImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION,
            "findByUuid",
            new String[] {
                String.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID = new FinderPath(LiferayServiceModelImpl.ENTITY_CACHE_ENABLED,
            LiferayServiceModelImpl.FINDER_CACHE_ENABLED,
            LiferayServiceImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid",
            new String[] { String.class.getName() },
            LiferayServiceModelImpl.UUID_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_UUID = new FinderPath(LiferayServiceModelImpl.ENTITY_CACHE_ENABLED,
            LiferayServiceModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid",
            new String[] { String.class.getName() });
    private static final String _FINDER_COLUMN_UUID_UUID_1 = "liferayService.uuid IS NULL";
    private static final String _FINDER_COLUMN_UUID_UUID_2 = "liferayService.uuid = ?";
    private static final String _FINDER_COLUMN_UUID_UUID_3 = "(liferayService.uuid IS NULL OR liferayService.uuid = '')";
    private static final String _SQL_SELECT_LIFERAYSERVICE = "SELECT liferayService FROM LiferayService liferayService";
    private static final String _SQL_SELECT_LIFERAYSERVICE_WHERE = "SELECT liferayService FROM LiferayService liferayService WHERE ";
    private static final String _SQL_COUNT_LIFERAYSERVICE = "SELECT COUNT(liferayService) FROM LiferayService liferayService";
    private static final String _SQL_COUNT_LIFERAYSERVICE_WHERE = "SELECT COUNT(liferayService) FROM LiferayService liferayService WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "liferayService.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No LiferayService exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No LiferayService exists with the key {";
    private static final boolean _HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE = GetterUtil.getBoolean(PropsUtil.get(
                PropsKeys.HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE));
    private static Log _log = LogFactoryUtil.getLog(LiferayServicePersistenceImpl.class);
    private static Set<String> _badColumnNames = SetUtil.fromArray(new String[] {
                "uuid"
            });
    private static LiferayService _nullLiferayService = new LiferayServiceImpl() {
            @Override
            public Object clone() {
                return this;
            }

            @Override
            public CacheModel<LiferayService> toCacheModel() {
                return _nullLiferayServiceCacheModel;
            }
        };

    private static CacheModel<LiferayService> _nullLiferayServiceCacheModel = new CacheModel<LiferayService>() {
            @Override
            public LiferayService toEntityModel() {
                return _nullLiferayService;
            }
        };

    public LiferayServicePersistenceImpl() {
        setModelClass(LiferayService.class);
    }

    /**
     * Returns all the liferay services where uuid = &#63;.
     *
     * @param uuid the uuid
     * @return the matching liferay services
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<LiferayService> findByUuid(String uuid)
        throws SystemException {
        return findByUuid(uuid, QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the liferay services where uuid = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.med.mhv.liferay.model.impl.LiferayServiceModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param uuid the uuid
     * @param start the lower bound of the range of liferay services
     * @param end the upper bound of the range of liferay services (not inclusive)
     * @return the range of matching liferay services
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<LiferayService> findByUuid(String uuid, int start, int end)
        throws SystemException {
        return findByUuid(uuid, start, end, null);
    }

    /**
     * Returns an ordered range of all the liferay services where uuid = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.med.mhv.liferay.model.impl.LiferayServiceModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param uuid the uuid
     * @param start the lower bound of the range of liferay services
     * @param end the upper bound of the range of liferay services (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching liferay services
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<LiferayService> findByUuid(String uuid, int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID;
            finderArgs = new Object[] { uuid };
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_UUID;
            finderArgs = new Object[] { uuid, start, end, orderByComparator };
        }

        List<LiferayService> list = (List<LiferayService>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (LiferayService liferayService : list) {
                if (!Validator.equals(uuid, liferayService.getUuid())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(3 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(3);
            }

            query.append(_SQL_SELECT_LIFERAYSERVICE_WHERE);

            boolean bindUuid = false;

            if (uuid == null) {
                query.append(_FINDER_COLUMN_UUID_UUID_1);
            } else if (uuid.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;

                query.append(_FINDER_COLUMN_UUID_UUID_2);
            }

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(LiferayServiceModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                if (bindUuid) {
                    qPos.add(uuid);
                }

                if (!pagination) {
                    list = (List<LiferayService>) QueryUtil.list(q,
                            getDialect(), start, end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<LiferayService>(list);
                } else {
                    list = (List<LiferayService>) QueryUtil.list(q,
                            getDialect(), start, end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first liferay service in the ordered set where uuid = &#63;.
     *
     * @param uuid the uuid
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching liferay service
     * @throws gov.va.med.mhv.liferay.NoSuchLiferayServiceException if a matching liferay service could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public LiferayService findByUuid_First(String uuid,
        OrderByComparator orderByComparator)
        throws NoSuchLiferayServiceException, SystemException {
        LiferayService liferayService = fetchByUuid_First(uuid,
                orderByComparator);

        if (liferayService != null) {
            return liferayService;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("uuid=");
        msg.append(uuid);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchLiferayServiceException(msg.toString());
    }

    /**
     * Returns the first liferay service in the ordered set where uuid = &#63;.
     *
     * @param uuid the uuid
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching liferay service, or <code>null</code> if a matching liferay service could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public LiferayService fetchByUuid_First(String uuid,
        OrderByComparator orderByComparator) throws SystemException {
        List<LiferayService> list = findByUuid(uuid, 0, 1, orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last liferay service in the ordered set where uuid = &#63;.
     *
     * @param uuid the uuid
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching liferay service
     * @throws gov.va.med.mhv.liferay.NoSuchLiferayServiceException if a matching liferay service could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public LiferayService findByUuid_Last(String uuid,
        OrderByComparator orderByComparator)
        throws NoSuchLiferayServiceException, SystemException {
        LiferayService liferayService = fetchByUuid_Last(uuid, orderByComparator);

        if (liferayService != null) {
            return liferayService;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("uuid=");
        msg.append(uuid);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchLiferayServiceException(msg.toString());
    }

    /**
     * Returns the last liferay service in the ordered set where uuid = &#63;.
     *
     * @param uuid the uuid
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching liferay service, or <code>null</code> if a matching liferay service could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public LiferayService fetchByUuid_Last(String uuid,
        OrderByComparator orderByComparator) throws SystemException {
        int count = countByUuid(uuid);

        if (count == 0) {
            return null;
        }

        List<LiferayService> list = findByUuid(uuid, count - 1, count,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the liferay services before and after the current liferay service in the ordered set where uuid = &#63;.
     *
     * @param sessionid the primary key of the current liferay service
     * @param uuid the uuid
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next liferay service
     * @throws gov.va.med.mhv.liferay.NoSuchLiferayServiceException if a liferay service with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public LiferayService[] findByUuid_PrevAndNext(long sessionid, String uuid,
        OrderByComparator orderByComparator)
        throws NoSuchLiferayServiceException, SystemException {
        LiferayService liferayService = findByPrimaryKey(sessionid);

        Session session = null;

        try {
            session = openSession();

            LiferayService[] array = new LiferayServiceImpl[3];

            array[0] = getByUuid_PrevAndNext(session, liferayService, uuid,
                    orderByComparator, true);

            array[1] = liferayService;

            array[2] = getByUuid_PrevAndNext(session, liferayService, uuid,
                    orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected LiferayService getByUuid_PrevAndNext(Session session,
        LiferayService liferayService, String uuid,
        OrderByComparator orderByComparator, boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_LIFERAYSERVICE_WHERE);

        boolean bindUuid = false;

        if (uuid == null) {
            query.append(_FINDER_COLUMN_UUID_UUID_1);
        } else if (uuid.equals(StringPool.BLANK)) {
            query.append(_FINDER_COLUMN_UUID_UUID_3);
        } else {
            bindUuid = true;

            query.append(_FINDER_COLUMN_UUID_UUID_2);
        }

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(LiferayServiceModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        if (bindUuid) {
            qPos.add(uuid);
        }

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(liferayService);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<LiferayService> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Removes all the liferay services where uuid = &#63; from the database.
     *
     * @param uuid the uuid
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeByUuid(String uuid) throws SystemException {
        for (LiferayService liferayService : findByUuid(uuid,
                QueryUtil.ALL_POS, QueryUtil.ALL_POS, null)) {
            remove(liferayService);
        }
    }

    /**
     * Returns the number of liferay services where uuid = &#63;.
     *
     * @param uuid the uuid
     * @return the number of matching liferay services
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByUuid(String uuid) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_UUID;

        Object[] finderArgs = new Object[] { uuid };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(2);

            query.append(_SQL_COUNT_LIFERAYSERVICE_WHERE);

            boolean bindUuid = false;

            if (uuid == null) {
                query.append(_FINDER_COLUMN_UUID_UUID_1);
            } else if (uuid.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;

                query.append(_FINDER_COLUMN_UUID_UUID_2);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                if (bindUuid) {
                    qPos.add(uuid);
                }

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Caches the liferay service in the entity cache if it is enabled.
     *
     * @param liferayService the liferay service
     */
    @Override
    public void cacheResult(LiferayService liferayService) {
        EntityCacheUtil.putResult(LiferayServiceModelImpl.ENTITY_CACHE_ENABLED,
            LiferayServiceImpl.class, liferayService.getPrimaryKey(),
            liferayService);

        liferayService.resetOriginalValues();
    }

    /**
     * Caches the liferay services in the entity cache if it is enabled.
     *
     * @param liferayServices the liferay services
     */
    @Override
    public void cacheResult(List<LiferayService> liferayServices) {
        for (LiferayService liferayService : liferayServices) {
            if (EntityCacheUtil.getResult(
                        LiferayServiceModelImpl.ENTITY_CACHE_ENABLED,
                        LiferayServiceImpl.class, liferayService.getPrimaryKey()) == null) {
                cacheResult(liferayService);
            } else {
                liferayService.resetOriginalValues();
            }
        }
    }

    /**
     * Clears the cache for all liferay services.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache() {
        if (_HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE) {
            CacheRegistryUtil.clear(LiferayServiceImpl.class.getName());
        }

        EntityCacheUtil.clearCache(LiferayServiceImpl.class.getName());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    /**
     * Clears the cache for the liferay service.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache(LiferayService liferayService) {
        EntityCacheUtil.removeResult(LiferayServiceModelImpl.ENTITY_CACHE_ENABLED,
            LiferayServiceImpl.class, liferayService.getPrimaryKey());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(List<LiferayService> liferayServices) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);

        for (LiferayService liferayService : liferayServices) {
            EntityCacheUtil.removeResult(LiferayServiceModelImpl.ENTITY_CACHE_ENABLED,
                LiferayServiceImpl.class, liferayService.getPrimaryKey());
        }
    }

    /**
     * Creates a new liferay service with the primary key. Does not add the liferay service to the database.
     *
     * @param sessionid the primary key for the new liferay service
     * @return the new liferay service
     */
    @Override
    public LiferayService create(long sessionid) {
        LiferayService liferayService = new LiferayServiceImpl();

        liferayService.setNew(true);
        liferayService.setPrimaryKey(sessionid);

        String uuid = PortalUUIDUtil.generate();

        liferayService.setUuid(uuid);

        return liferayService;
    }

    /**
     * Removes the liferay service with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param sessionid the primary key of the liferay service
     * @return the liferay service that was removed
     * @throws gov.va.med.mhv.liferay.NoSuchLiferayServiceException if a liferay service with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public LiferayService remove(long sessionid)
        throws NoSuchLiferayServiceException, SystemException {
        return remove((Serializable) sessionid);
    }

    /**
     * Removes the liferay service with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param primaryKey the primary key of the liferay service
     * @return the liferay service that was removed
     * @throws gov.va.med.mhv.liferay.NoSuchLiferayServiceException if a liferay service with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public LiferayService remove(Serializable primaryKey)
        throws NoSuchLiferayServiceException, SystemException {
        Session session = null;

        try {
            session = openSession();

            LiferayService liferayService = (LiferayService) session.get(LiferayServiceImpl.class,
                    primaryKey);

            if (liferayService == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }

                throw new NoSuchLiferayServiceException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                    primaryKey);
            }

            return remove(liferayService);
        } catch (NoSuchLiferayServiceException nsee) {
            throw nsee;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    @Override
    protected LiferayService removeImpl(LiferayService liferayService)
        throws SystemException {
        liferayService = toUnwrappedModel(liferayService);

        Session session = null;

        try {
            session = openSession();

            if (!session.contains(liferayService)) {
                liferayService = (LiferayService) session.get(LiferayServiceImpl.class,
                        liferayService.getPrimaryKeyObj());
            }

            if (liferayService != null) {
                session.delete(liferayService);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        if (liferayService != null) {
            clearCache(liferayService);
        }

        return liferayService;
    }

    @Override
    public LiferayService updateImpl(
        gov.va.med.mhv.liferay.model.LiferayService liferayService)
        throws SystemException {
        liferayService = toUnwrappedModel(liferayService);

        boolean isNew = liferayService.isNew();

        LiferayServiceModelImpl liferayServiceModelImpl = (LiferayServiceModelImpl) liferayService;

        if (Validator.isNull(liferayService.getUuid())) {
            String uuid = PortalUUIDUtil.generate();

            liferayService.setUuid(uuid);
        }

        Session session = null;

        try {
            session = openSession();

            if (liferayService.isNew()) {
                session.save(liferayService);

                liferayService.setNew(false);
            } else {
                session.merge(liferayService);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);

        if (isNew || !LiferayServiceModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        }
        else {
            if ((liferayServiceModelImpl.getColumnBitmask() &
                    FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID.getColumnBitmask()) != 0) {
                Object[] args = new Object[] {
                        liferayServiceModelImpl.getOriginalUuid()
                    };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_UUID, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID,
                    args);

                args = new Object[] { liferayServiceModelImpl.getUuid() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_UUID, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID,
                    args);
            }
        }

        EntityCacheUtil.putResult(LiferayServiceModelImpl.ENTITY_CACHE_ENABLED,
            LiferayServiceImpl.class, liferayService.getPrimaryKey(),
            liferayService);

        return liferayService;
    }

    protected LiferayService toUnwrappedModel(LiferayService liferayService) {
        if (liferayService instanceof LiferayServiceImpl) {
            return liferayService;
        }

        LiferayServiceImpl liferayServiceImpl = new LiferayServiceImpl();

        liferayServiceImpl.setNew(liferayService.isNew());
        liferayServiceImpl.setPrimaryKey(liferayService.getPrimaryKey());

        liferayServiceImpl.setUuid(liferayService.getUuid());
        liferayServiceImpl.setSessionid(liferayService.getSessionid());

        return liferayServiceImpl;
    }

    /**
     * Returns the liferay service with the primary key or throws a {@link com.liferay.portal.NoSuchModelException} if it could not be found.
     *
     * @param primaryKey the primary key of the liferay service
     * @return the liferay service
     * @throws gov.va.med.mhv.liferay.NoSuchLiferayServiceException if a liferay service with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public LiferayService findByPrimaryKey(Serializable primaryKey)
        throws NoSuchLiferayServiceException, SystemException {
        LiferayService liferayService = fetchByPrimaryKey(primaryKey);

        if (liferayService == null) {
            if (_log.isWarnEnabled()) {
                _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }

            throw new NoSuchLiferayServiceException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                primaryKey);
        }

        return liferayService;
    }

    /**
     * Returns the liferay service with the primary key or throws a {@link gov.va.med.mhv.liferay.NoSuchLiferayServiceException} if it could not be found.
     *
     * @param sessionid the primary key of the liferay service
     * @return the liferay service
     * @throws gov.va.med.mhv.liferay.NoSuchLiferayServiceException if a liferay service with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public LiferayService findByPrimaryKey(long sessionid)
        throws NoSuchLiferayServiceException, SystemException {
        return findByPrimaryKey((Serializable) sessionid);
    }

    /**
     * Returns the liferay service with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param primaryKey the primary key of the liferay service
     * @return the liferay service, or <code>null</code> if a liferay service with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public LiferayService fetchByPrimaryKey(Serializable primaryKey)
        throws SystemException {
        LiferayService liferayService = (LiferayService) EntityCacheUtil.getResult(LiferayServiceModelImpl.ENTITY_CACHE_ENABLED,
                LiferayServiceImpl.class, primaryKey);

        if (liferayService == _nullLiferayService) {
            return null;
        }

        if (liferayService == null) {
            Session session = null;

            try {
                session = openSession();

                liferayService = (LiferayService) session.get(LiferayServiceImpl.class,
                        primaryKey);

                if (liferayService != null) {
                    cacheResult(liferayService);
                } else {
                    EntityCacheUtil.putResult(LiferayServiceModelImpl.ENTITY_CACHE_ENABLED,
                        LiferayServiceImpl.class, primaryKey,
                        _nullLiferayService);
                }
            } catch (Exception e) {
                EntityCacheUtil.removeResult(LiferayServiceModelImpl.ENTITY_CACHE_ENABLED,
                    LiferayServiceImpl.class, primaryKey);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return liferayService;
    }

    /**
     * Returns the liferay service with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param sessionid the primary key of the liferay service
     * @return the liferay service, or <code>null</code> if a liferay service with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public LiferayService fetchByPrimaryKey(long sessionid)
        throws SystemException {
        return fetchByPrimaryKey((Serializable) sessionid);
    }

    /**
     * Returns all the liferay services.
     *
     * @return the liferay services
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<LiferayService> findAll() throws SystemException {
        return findAll(QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the liferay services.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.med.mhv.liferay.model.impl.LiferayServiceModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of liferay services
     * @param end the upper bound of the range of liferay services (not inclusive)
     * @return the range of liferay services
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<LiferayService> findAll(int start, int end)
        throws SystemException {
        return findAll(start, end, null);
    }

    /**
     * Returns an ordered range of all the liferay services.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.med.mhv.liferay.model.impl.LiferayServiceModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of liferay services
     * @param end the upper bound of the range of liferay services (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of liferay services
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<LiferayService> findAll(int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[] { start, end, orderByComparator };
        }

        List<LiferayService> list = (List<LiferayService>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if (list == null) {
            StringBundler query = null;
            String sql = null;

            if (orderByComparator != null) {
                query = new StringBundler(2 +
                        (orderByComparator.getOrderByFields().length * 3));

                query.append(_SQL_SELECT_LIFERAYSERVICE);

                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);

                sql = query.toString();
            } else {
                sql = _SQL_SELECT_LIFERAYSERVICE;

                if (pagination) {
                    sql = sql.concat(LiferayServiceModelImpl.ORDER_BY_JPQL);
                }
            }

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                if (!pagination) {
                    list = (List<LiferayService>) QueryUtil.list(q,
                            getDialect(), start, end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<LiferayService>(list);
                } else {
                    list = (List<LiferayService>) QueryUtil.list(q,
                            getDialect(), start, end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Removes all the liferay services from the database.
     *
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeAll() throws SystemException {
        for (LiferayService liferayService : findAll()) {
            remove(liferayService);
        }
    }

    /**
     * Returns the number of liferay services.
     *
     * @return the number of liferay services
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countAll() throws SystemException {
        Long count = (Long) FinderCacheUtil.getResult(FINDER_PATH_COUNT_ALL,
                FINDER_ARGS_EMPTY, this);

        if (count == null) {
            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(_SQL_COUNT_LIFERAYSERVICE);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    @Override
    protected Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    /**
     * Initializes the liferay service persistence.
     */
    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split(GetterUtil.getString(
                    com.liferay.util.service.ServiceProps.get(
                        "value.object.listener.gov.va.med.mhv.liferay.model.LiferayService")));

        if (listenerClassNames.length > 0) {
            try {
                List<ModelListener<LiferayService>> listenersList = new ArrayList<ModelListener<LiferayService>>();

                for (String listenerClassName : listenerClassNames) {
                    listenersList.add((ModelListener<LiferayService>) InstanceFactory.newInstance(
                            getClassLoader(), listenerClassName));
                }

                listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            } catch (Exception e) {
                _log.error(e);
            }
        }
    }

    public void destroy() {
        EntityCacheUtil.removeCache(LiferayServiceImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}
