package gov.va.med.mhv.liferay.service.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Properties;
import com.liferay.portal.util.PortalUtil;


import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.security.ac.AccessControlled;

import gov.va.med.mhv.liferay.service.base.LiferayServiceServiceBaseImpl;

/**
 * The implementation of the liferay service remote service.
 *
 * <p>
 * All custom service methods should be put in this class. Whenever methods are added, rerun ServiceBuilder to copy their definitions into the {@link gov.va.med.mhv.liferay.service.LiferayServiceService} interface.
 *
 * <p>
 * This is a remote service. Methods of this service are expected to have security checks based on the propagated JAAS credentials because this service can be accessed remotely.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see gov.va.med.mhv.liferay.service.base.LiferayServiceServiceBaseImpl
 * @see gov.va.med.mhv.liferay.service.LiferayServiceServiceUtil
 */
public class LiferayServiceServiceImpl extends LiferayServiceServiceBaseImpl {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never reference this interface directly. Always use {@link gov.va.med.mhv.liferay.service.LiferayServiceServiceUtil} to access the liferay service remote service.
     */
	
	@AccessControlled(guestAccessEnabled = true,  hostAllowedValidationEnabled = false)
	public boolean isLiferaySessionAvailable() throws Exception {
		
		long allowedUsers = Long.parseLong(PropsUtil.get("max.beta.users.allowed"));
		Class<?> liveUsers = PortalClassLoaderUtil.getClassLoader().loadClass("com.liferay.portal.liveusers.LiveUsers");
        Method getSessionUsers = liveUsers.getDeclaredMethod("getSessionUsersCount", long.class); 
        int users = (Integer) getSessionUsers.invoke(null, PortalUtil.getDefaultCompanyId());
        System.out.println("company id: "+ PortalUtil.getDefaultCompanyId());
        System.out.println("users: "+ users);
        if (users > allowedUsers){
        	return false;
        }
        return true;

	}
}
