package gov.va.med.mhv.liferay.service.impl;

import gov.va.med.mhv.liferay.service.base.LiferayServiceLocalServiceBaseImpl;

/**
 * The implementation of the liferay service local service.
 *
 * <p>
 * All custom service methods should be put in this class. Whenever methods are added, rerun ServiceBuilder to copy their definitions into the {@link gov.va.med.mhv.liferay.service.LiferayServiceLocalService} interface.
 *
 * <p>
 * This is a local service. Methods of this service will not have security checks based on the propagated JAAS credentials because this service can only be accessed from within the same VM.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see gov.va.med.mhv.liferay.service.base.LiferayServiceLocalServiceBaseImpl
 * @see gov.va.med.mhv.liferay.service.LiferayServiceLocalServiceUtil
 */
public class LiferayServiceLocalServiceImpl
    extends LiferayServiceLocalServiceBaseImpl {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never reference this interface directly. Always use {@link gov.va.med.mhv.liferay.service.LiferayServiceLocalServiceUtil} to access the liferay service local service.
     */
}
