package gov.va.med.mhv.liferay.service.http;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

import gov.va.med.mhv.liferay.service.LiferayServiceServiceUtil;

import java.rmi.RemoteException;

/**
 * Provides the SOAP utility for the
 * {@link gov.va.med.mhv.liferay.service.LiferayServiceServiceUtil} service utility. The
 * static methods of this class calls the same methods of the service utility.
 * However, the signatures are different because it is difficult for SOAP to
 * support certain types.
 *
 * <p>
 * ServiceBuilder follows certain rules in translating the methods. For example,
 * if the method in the service utility returns a {@link java.util.List}, that
 * is translated to an array of {@link gov.va.med.mhv.liferay.model.LiferayServiceSoap}.
 * If the method in the service utility returns a
 * {@link gov.va.med.mhv.liferay.model.LiferayService}, that is translated to a
 * {@link gov.va.med.mhv.liferay.model.LiferayServiceSoap}. Methods that SOAP cannot
 * safely wire are skipped.
 * </p>
 *
 * <p>
 * The benefits of using the SOAP utility is that it is cross platform
 * compatible. SOAP allows different languages like Java, .NET, C++, PHP, and
 * even Perl, to call the generated services. One drawback of SOAP is that it is
 * slow because it needs to serialize all calls into a text format (XML).
 * </p>
 *
 * <p>
 * You can see a list of services at http://localhost:8080/api/axis. Set the
 * property <b>axis.servlet.hosts.allowed</b> in portal.properties to configure
 * security.
 * </p>
 *
 * <p>
 * The SOAP utility is only generated for remote services.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see LiferayServiceServiceHttp
 * @see gov.va.med.mhv.liferay.model.LiferayServiceSoap
 * @see gov.va.med.mhv.liferay.service.LiferayServiceServiceUtil
 * @generated
 */
public class LiferayServiceServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(LiferayServiceServiceSoap.class);

    public static boolean isLiferaySessionAvailable() throws RemoteException {
        try {
            boolean returnValue = LiferayServiceServiceUtil.isLiferaySessionAvailable();

            return returnValue;
        } catch (Exception e) {
            _log.error(e, e);

            throw new RemoteException(e.getMessage());
        }
    }
}
