package gov.va.med.mhv.liferay.service.base;

import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.bean.IdentifiableBean;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.service.BaseServiceImpl;
import com.liferay.portal.service.persistence.UserPersistence;

import gov.va.med.mhv.liferay.model.LiferayService;
import gov.va.med.mhv.liferay.service.LiferayServiceService;
import gov.va.med.mhv.liferay.service.persistence.LiferayServicePersistence;

import javax.sql.DataSource;

/**
 * Provides the base implementation for the liferay service remote service.
 *
 * <p>
 * This implementation exists only as a container for the default service methods generated by ServiceBuilder. All custom service methods should be put in {@link gov.va.med.mhv.liferay.service.impl.LiferayServiceServiceImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see gov.va.med.mhv.liferay.service.impl.LiferayServiceServiceImpl
 * @see gov.va.med.mhv.liferay.service.LiferayServiceServiceUtil
 * @generated
 */
public abstract class LiferayServiceServiceBaseImpl extends BaseServiceImpl
    implements LiferayServiceService, IdentifiableBean {
    @BeanReference(type = gov.va.med.mhv.liferay.service.LiferayServiceLocalService.class)
    protected gov.va.med.mhv.liferay.service.LiferayServiceLocalService liferayServiceLocalService;
    @BeanReference(type = gov.va.med.mhv.liferay.service.LiferayServiceService.class)
    protected gov.va.med.mhv.liferay.service.LiferayServiceService liferayServiceService;
    @BeanReference(type = LiferayServicePersistence.class)
    protected LiferayServicePersistence liferayServicePersistence;
    @BeanReference(type = com.liferay.counter.service.CounterLocalService.class)
    protected com.liferay.counter.service.CounterLocalService counterLocalService;
    @BeanReference(type = com.liferay.portal.service.ResourceLocalService.class)
    protected com.liferay.portal.service.ResourceLocalService resourceLocalService;
    @BeanReference(type = com.liferay.portal.service.UserLocalService.class)
    protected com.liferay.portal.service.UserLocalService userLocalService;
    @BeanReference(type = com.liferay.portal.service.UserService.class)
    protected com.liferay.portal.service.UserService userService;
    @BeanReference(type = UserPersistence.class)
    protected UserPersistence userPersistence;
    private String _beanIdentifier;
    private ClassLoader _classLoader;
    private LiferayServiceServiceClpInvoker _clpInvoker = new LiferayServiceServiceClpInvoker();

    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. Always use {@link gov.va.med.mhv.liferay.service.LiferayServiceServiceUtil} to access the liferay service remote service.
     */

    /**
     * Returns the liferay service local service.
     *
     * @return the liferay service local service
     */
    public gov.va.med.mhv.liferay.service.LiferayServiceLocalService getLiferayServiceLocalService() {
        return liferayServiceLocalService;
    }

    /**
     * Sets the liferay service local service.
     *
     * @param liferayServiceLocalService the liferay service local service
     */
    public void setLiferayServiceLocalService(
        gov.va.med.mhv.liferay.service.LiferayServiceLocalService liferayServiceLocalService) {
        this.liferayServiceLocalService = liferayServiceLocalService;
    }

    /**
     * Returns the liferay service remote service.
     *
     * @return the liferay service remote service
     */
    public gov.va.med.mhv.liferay.service.LiferayServiceService getLiferayServiceService() {
        return liferayServiceService;
    }

    /**
     * Sets the liferay service remote service.
     *
     * @param liferayServiceService the liferay service remote service
     */
    public void setLiferayServiceService(
        gov.va.med.mhv.liferay.service.LiferayServiceService liferayServiceService) {
        this.liferayServiceService = liferayServiceService;
    }

    /**
     * Returns the liferay service persistence.
     *
     * @return the liferay service persistence
     */
    public LiferayServicePersistence getLiferayServicePersistence() {
        return liferayServicePersistence;
    }

    /**
     * Sets the liferay service persistence.
     *
     * @param liferayServicePersistence the liferay service persistence
     */
    public void setLiferayServicePersistence(
        LiferayServicePersistence liferayServicePersistence) {
        this.liferayServicePersistence = liferayServicePersistence;
    }

    /**
     * Returns the counter local service.
     *
     * @return the counter local service
     */
    public com.liferay.counter.service.CounterLocalService getCounterLocalService() {
        return counterLocalService;
    }

    /**
     * Sets the counter local service.
     *
     * @param counterLocalService the counter local service
     */
    public void setCounterLocalService(
        com.liferay.counter.service.CounterLocalService counterLocalService) {
        this.counterLocalService = counterLocalService;
    }

    /**
     * Returns the resource local service.
     *
     * @return the resource local service
     */
    public com.liferay.portal.service.ResourceLocalService getResourceLocalService() {
        return resourceLocalService;
    }

    /**
     * Sets the resource local service.
     *
     * @param resourceLocalService the resource local service
     */
    public void setResourceLocalService(
        com.liferay.portal.service.ResourceLocalService resourceLocalService) {
        this.resourceLocalService = resourceLocalService;
    }

    /**
     * Returns the user local service.
     *
     * @return the user local service
     */
    public com.liferay.portal.service.UserLocalService getUserLocalService() {
        return userLocalService;
    }

    /**
     * Sets the user local service.
     *
     * @param userLocalService the user local service
     */
    public void setUserLocalService(
        com.liferay.portal.service.UserLocalService userLocalService) {
        this.userLocalService = userLocalService;
    }

    /**
     * Returns the user remote service.
     *
     * @return the user remote service
     */
    public com.liferay.portal.service.UserService getUserService() {
        return userService;
    }

    /**
     * Sets the user remote service.
     *
     * @param userService the user remote service
     */
    public void setUserService(
        com.liferay.portal.service.UserService userService) {
        this.userService = userService;
    }

    /**
     * Returns the user persistence.
     *
     * @return the user persistence
     */
    public UserPersistence getUserPersistence() {
        return userPersistence;
    }

    /**
     * Sets the user persistence.
     *
     * @param userPersistence the user persistence
     */
    public void setUserPersistence(UserPersistence userPersistence) {
        this.userPersistence = userPersistence;
    }

    public void afterPropertiesSet() {
        Class<?> clazz = getClass();

        _classLoader = clazz.getClassLoader();
    }

    public void destroy() {
    }

    /**
     * Returns the Spring bean ID for this bean.
     *
     * @return the Spring bean ID for this bean
     */
    @Override
    public String getBeanIdentifier() {
        return _beanIdentifier;
    }

    /**
     * Sets the Spring bean ID for this bean.
     *
     * @param beanIdentifier the Spring bean ID for this bean
     */
    @Override
    public void setBeanIdentifier(String beanIdentifier) {
        _beanIdentifier = beanIdentifier;
    }

    @Override
    public Object invokeMethod(String name, String[] parameterTypes,
        Object[] arguments) throws Throwable {
        Thread currentThread = Thread.currentThread();

        ClassLoader contextClassLoader = currentThread.getContextClassLoader();

        if (contextClassLoader != _classLoader) {
            currentThread.setContextClassLoader(_classLoader);
        }

        try {
            return _clpInvoker.invokeMethod(name, parameterTypes, arguments);
        } finally {
            if (contextClassLoader != _classLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    protected Class<?> getModelClass() {
        return LiferayService.class;
    }

    protected String getModelClassName() {
        return LiferayService.class.getName();
    }

    /**
     * Performs an SQL query.
     *
     * @param sql the sql query
     */
    protected void runSQL(String sql) throws SystemException {
        try {
            DataSource dataSource = liferayServicePersistence.getDataSource();

            SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate(dataSource,
                    sql, new int[0]);

            sqlUpdate.update();
        } catch (Exception e) {
            throw new SystemException(e);
        }
    }
}
