package gov.va.med.mhv.liferay.service.base;

import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.bean.IdentifiableBean;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.model.PersistedModel;
import com.liferay.portal.service.BaseLocalServiceImpl;
import com.liferay.portal.service.PersistedModelLocalServiceRegistryUtil;
import com.liferay.portal.service.persistence.UserPersistence;

import gov.va.med.mhv.liferay.model.LiferayService;
import gov.va.med.mhv.liferay.service.LiferayServiceLocalService;
import gov.va.med.mhv.liferay.service.persistence.LiferayServicePersistence;

import java.io.Serializable;

import java.util.List;

import javax.sql.DataSource;

/**
 * Provides the base implementation for the liferay service local service.
 *
 * <p>
 * This implementation exists only as a container for the default service methods generated by ServiceBuilder. All custom service methods should be put in {@link gov.va.med.mhv.liferay.service.impl.LiferayServiceLocalServiceImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see gov.va.med.mhv.liferay.service.impl.LiferayServiceLocalServiceImpl
 * @see gov.va.med.mhv.liferay.service.LiferayServiceLocalServiceUtil
 * @generated
 */
public abstract class LiferayServiceLocalServiceBaseImpl
    extends BaseLocalServiceImpl implements LiferayServiceLocalService,
        IdentifiableBean {
    @BeanReference(type = gov.va.med.mhv.liferay.service.LiferayServiceLocalService.class)
    protected gov.va.med.mhv.liferay.service.LiferayServiceLocalService liferayServiceLocalService;
    @BeanReference(type = gov.va.med.mhv.liferay.service.LiferayServiceService.class)
    protected gov.va.med.mhv.liferay.service.LiferayServiceService liferayServiceService;
    @BeanReference(type = LiferayServicePersistence.class)
    protected LiferayServicePersistence liferayServicePersistence;
    @BeanReference(type = com.liferay.counter.service.CounterLocalService.class)
    protected com.liferay.counter.service.CounterLocalService counterLocalService;
    @BeanReference(type = com.liferay.portal.service.ResourceLocalService.class)
    protected com.liferay.portal.service.ResourceLocalService resourceLocalService;
    @BeanReference(type = com.liferay.portal.service.UserLocalService.class)
    protected com.liferay.portal.service.UserLocalService userLocalService;
    @BeanReference(type = com.liferay.portal.service.UserService.class)
    protected com.liferay.portal.service.UserService userService;
    @BeanReference(type = UserPersistence.class)
    protected UserPersistence userPersistence;
    private String _beanIdentifier;
    private ClassLoader _classLoader;
    private LiferayServiceLocalServiceClpInvoker _clpInvoker = new LiferayServiceLocalServiceClpInvoker();

    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. Always use {@link gov.va.med.mhv.liferay.service.LiferayServiceLocalServiceUtil} to access the liferay service local service.
     */

    /**
     * Adds the liferay service to the database. Also notifies the appropriate model listeners.
     *
     * @param liferayService the liferay service
     * @return the liferay service that was added
     * @throws SystemException if a system exception occurred
     */
    @Indexable(type = IndexableType.REINDEX)
    @Override
    public LiferayService addLiferayService(LiferayService liferayService)
        throws SystemException {
        liferayService.setNew(true);

        return liferayServicePersistence.update(liferayService);
    }

    /**
     * Creates a new liferay service with the primary key. Does not add the liferay service to the database.
     *
     * @param sessionid the primary key for the new liferay service
     * @return the new liferay service
     */
    @Override
    public LiferayService createLiferayService(long sessionid) {
        return liferayServicePersistence.create(sessionid);
    }

    /**
     * Deletes the liferay service with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param sessionid the primary key of the liferay service
     * @return the liferay service that was removed
     * @throws PortalException if a liferay service with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Indexable(type = IndexableType.DELETE)
    @Override
    public LiferayService deleteLiferayService(long sessionid)
        throws PortalException, SystemException {
        return liferayServicePersistence.remove(sessionid);
    }

    /**
     * Deletes the liferay service from the database. Also notifies the appropriate model listeners.
     *
     * @param liferayService the liferay service
     * @return the liferay service that was removed
     * @throws SystemException if a system exception occurred
     */
    @Indexable(type = IndexableType.DELETE)
    @Override
    public LiferayService deleteLiferayService(LiferayService liferayService)
        throws SystemException {
        return liferayServicePersistence.remove(liferayService);
    }

    @Override
    public DynamicQuery dynamicQuery() {
        Class<?> clazz = getClass();

        return DynamicQueryFactoryUtil.forClass(LiferayService.class,
            clazz.getClassLoader());
    }

    /**
     * Performs a dynamic query on the database and returns the matching rows.
     *
     * @param dynamicQuery the dynamic query
     * @return the matching rows
     * @throws SystemException if a system exception occurred
     */
    @Override
    @SuppressWarnings("rawtypes")
    public List dynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return liferayServicePersistence.findWithDynamicQuery(dynamicQuery);
    }

    /**
     * Performs a dynamic query on the database and returns a range of the matching rows.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.med.mhv.liferay.model.impl.LiferayServiceModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param dynamicQuery the dynamic query
     * @param start the lower bound of the range of model instances
     * @param end the upper bound of the range of model instances (not inclusive)
     * @return the range of matching rows
     * @throws SystemException if a system exception occurred
     */
    @Override
    @SuppressWarnings("rawtypes")
    public List dynamicQuery(DynamicQuery dynamicQuery, int start, int end)
        throws SystemException {
        return liferayServicePersistence.findWithDynamicQuery(dynamicQuery,
            start, end);
    }

    /**
     * Performs a dynamic query on the database and returns an ordered range of the matching rows.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.med.mhv.liferay.model.impl.LiferayServiceModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param dynamicQuery the dynamic query
     * @param start the lower bound of the range of model instances
     * @param end the upper bound of the range of model instances (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching rows
     * @throws SystemException if a system exception occurred
     */
    @Override
    @SuppressWarnings("rawtypes")
    public List dynamicQuery(DynamicQuery dynamicQuery, int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        return liferayServicePersistence.findWithDynamicQuery(dynamicQuery,
            start, end, orderByComparator);
    }

    /**
     * Returns the number of rows that match the dynamic query.
     *
     * @param dynamicQuery the dynamic query
     * @return the number of rows that match the dynamic query
     * @throws SystemException if a system exception occurred
     */
    @Override
    public long dynamicQueryCount(DynamicQuery dynamicQuery)
        throws SystemException {
        return liferayServicePersistence.countWithDynamicQuery(dynamicQuery);
    }

    /**
     * Returns the number of rows that match the dynamic query.
     *
     * @param dynamicQuery the dynamic query
     * @param projection the projection to apply to the query
     * @return the number of rows that match the dynamic query
     * @throws SystemException if a system exception occurred
     */
    @Override
    public long dynamicQueryCount(DynamicQuery dynamicQuery,
        Projection projection) throws SystemException {
        return liferayServicePersistence.countWithDynamicQuery(dynamicQuery,
            projection);
    }

    @Override
    public LiferayService fetchLiferayService(long sessionid)
        throws SystemException {
        return liferayServicePersistence.fetchByPrimaryKey(sessionid);
    }

    /**
     * Returns the liferay service with the primary key.
     *
     * @param sessionid the primary key of the liferay service
     * @return the liferay service
     * @throws PortalException if a liferay service with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public LiferayService getLiferayService(long sessionid)
        throws PortalException, SystemException {
        return liferayServicePersistence.findByPrimaryKey(sessionid);
    }

    @Override
    public PersistedModel getPersistedModel(Serializable primaryKeyObj)
        throws PortalException, SystemException {
        return liferayServicePersistence.findByPrimaryKey(primaryKeyObj);
    }

    /**
     * Returns a range of all the liferay services.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.med.mhv.liferay.model.impl.LiferayServiceModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of liferay services
     * @param end the upper bound of the range of liferay services (not inclusive)
     * @return the range of liferay services
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<LiferayService> getLiferayServices(int start, int end)
        throws SystemException {
        return liferayServicePersistence.findAll(start, end);
    }

    /**
     * Returns the number of liferay services.
     *
     * @return the number of liferay services
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int getLiferayServicesCount() throws SystemException {
        return liferayServicePersistence.countAll();
    }

    /**
     * Updates the liferay service in the database or adds it if it does not yet exist. Also notifies the appropriate model listeners.
     *
     * @param liferayService the liferay service
     * @return the liferay service that was updated
     * @throws SystemException if a system exception occurred
     */
    @Indexable(type = IndexableType.REINDEX)
    @Override
    public LiferayService updateLiferayService(LiferayService liferayService)
        throws SystemException {
        return liferayServicePersistence.update(liferayService);
    }

    /**
     * Returns the liferay service local service.
     *
     * @return the liferay service local service
     */
    public gov.va.med.mhv.liferay.service.LiferayServiceLocalService getLiferayServiceLocalService() {
        return liferayServiceLocalService;
    }

    /**
     * Sets the liferay service local service.
     *
     * @param liferayServiceLocalService the liferay service local service
     */
    public void setLiferayServiceLocalService(
        gov.va.med.mhv.liferay.service.LiferayServiceLocalService liferayServiceLocalService) {
        this.liferayServiceLocalService = liferayServiceLocalService;
    }

    /**
     * Returns the liferay service remote service.
     *
     * @return the liferay service remote service
     */
    public gov.va.med.mhv.liferay.service.LiferayServiceService getLiferayServiceService() {
        return liferayServiceService;
    }

    /**
     * Sets the liferay service remote service.
     *
     * @param liferayServiceService the liferay service remote service
     */
    public void setLiferayServiceService(
        gov.va.med.mhv.liferay.service.LiferayServiceService liferayServiceService) {
        this.liferayServiceService = liferayServiceService;
    }

    /**
     * Returns the liferay service persistence.
     *
     * @return the liferay service persistence
     */
    public LiferayServicePersistence getLiferayServicePersistence() {
        return liferayServicePersistence;
    }

    /**
     * Sets the liferay service persistence.
     *
     * @param liferayServicePersistence the liferay service persistence
     */
    public void setLiferayServicePersistence(
        LiferayServicePersistence liferayServicePersistence) {
        this.liferayServicePersistence = liferayServicePersistence;
    }

    /**
     * Returns the counter local service.
     *
     * @return the counter local service
     */
    public com.liferay.counter.service.CounterLocalService getCounterLocalService() {
        return counterLocalService;
    }

    /**
     * Sets the counter local service.
     *
     * @param counterLocalService the counter local service
     */
    public void setCounterLocalService(
        com.liferay.counter.service.CounterLocalService counterLocalService) {
        this.counterLocalService = counterLocalService;
    }

    /**
     * Returns the resource local service.
     *
     * @return the resource local service
     */
    public com.liferay.portal.service.ResourceLocalService getResourceLocalService() {
        return resourceLocalService;
    }

    /**
     * Sets the resource local service.
     *
     * @param resourceLocalService the resource local service
     */
    public void setResourceLocalService(
        com.liferay.portal.service.ResourceLocalService resourceLocalService) {
        this.resourceLocalService = resourceLocalService;
    }

    /**
     * Returns the user local service.
     *
     * @return the user local service
     */
    public com.liferay.portal.service.UserLocalService getUserLocalService() {
        return userLocalService;
    }

    /**
     * Sets the user local service.
     *
     * @param userLocalService the user local service
     */
    public void setUserLocalService(
        com.liferay.portal.service.UserLocalService userLocalService) {
        this.userLocalService = userLocalService;
    }

    /**
     * Returns the user remote service.
     *
     * @return the user remote service
     */
    public com.liferay.portal.service.UserService getUserService() {
        return userService;
    }

    /**
     * Sets the user remote service.
     *
     * @param userService the user remote service
     */
    public void setUserService(
        com.liferay.portal.service.UserService userService) {
        this.userService = userService;
    }

    /**
     * Returns the user persistence.
     *
     * @return the user persistence
     */
    public UserPersistence getUserPersistence() {
        return userPersistence;
    }

    /**
     * Sets the user persistence.
     *
     * @param userPersistence the user persistence
     */
    public void setUserPersistence(UserPersistence userPersistence) {
        this.userPersistence = userPersistence;
    }

    public void afterPropertiesSet() {
        Class<?> clazz = getClass();

        _classLoader = clazz.getClassLoader();

        PersistedModelLocalServiceRegistryUtil.register("gov.va.med.mhv.liferay.model.LiferayService",
            liferayServiceLocalService);
    }

    public void destroy() {
        PersistedModelLocalServiceRegistryUtil.unregister(
            "gov.va.med.mhv.liferay.model.LiferayService");
    }

    /**
     * Returns the Spring bean ID for this bean.
     *
     * @return the Spring bean ID for this bean
     */
    @Override
    public String getBeanIdentifier() {
        return _beanIdentifier;
    }

    /**
     * Sets the Spring bean ID for this bean.
     *
     * @param beanIdentifier the Spring bean ID for this bean
     */
    @Override
    public void setBeanIdentifier(String beanIdentifier) {
        _beanIdentifier = beanIdentifier;
    }

    @Override
    public Object invokeMethod(String name, String[] parameterTypes,
        Object[] arguments) throws Throwable {
        Thread currentThread = Thread.currentThread();

        ClassLoader contextClassLoader = currentThread.getContextClassLoader();

        if (contextClassLoader != _classLoader) {
            currentThread.setContextClassLoader(_classLoader);
        }

        try {
            return _clpInvoker.invokeMethod(name, parameterTypes, arguments);
        } finally {
            if (contextClassLoader != _classLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    protected Class<?> getModelClass() {
        return LiferayService.class;
    }

    protected String getModelClassName() {
        return LiferayService.class.getName();
    }

    /**
     * Performs an SQL query.
     *
     * @param sql the sql query
     */
    protected void runSQL(String sql) throws SystemException {
        try {
            DataSource dataSource = liferayServicePersistence.getDataSource();

            SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate(dataSource,
                    sql, new int[0]);

            sqlUpdate.update();
        } catch (Exception e) {
            throw new SystemException(e);
        }
    }
}
