package gov.va.med.mhv.liferay.model.impl;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;

import gov.va.med.mhv.liferay.model.LiferayService;
import gov.va.med.mhv.liferay.model.LiferayServiceModel;
import gov.va.med.mhv.liferay.model.LiferayServiceSoap;

import java.io.Serializable;

import java.sql.Types;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * The base model implementation for the LiferayService service. Represents a row in the &quot;mhv_liferay_LiferayService&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link gov.va.med.mhv.liferay.model.LiferayServiceModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link LiferayServiceImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see LiferayServiceImpl
 * @see gov.va.med.mhv.liferay.model.LiferayService
 * @see gov.va.med.mhv.liferay.model.LiferayServiceModel
 * @generated
 */
@JSON(strict = true)
public class LiferayServiceModelImpl extends BaseModelImpl<LiferayService>
    implements LiferayServiceModel {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a liferay service model instance should use the {@link gov.va.med.mhv.liferay.model.LiferayService} interface instead.
     */
    public static final String TABLE_NAME = "mhv_liferay_LiferayService";
    public static final Object[][] TABLE_COLUMNS = {
            { "uuid_", Types.VARCHAR },
            { "sessionid", Types.BIGINT }
        };
    public static final String TABLE_SQL_CREATE = "create table mhv_liferay_LiferayService (uuid_ VARCHAR(75) null,sessionid LONG not null primary key)";
    public static final String TABLE_SQL_DROP = "drop table mhv_liferay_LiferayService";
    public static final String ORDER_BY_JPQL = " ORDER BY liferayService.sessionid ASC";
    public static final String ORDER_BY_SQL = " ORDER BY mhv_liferay_LiferayService.sessionid ASC";
    public static final String DATA_SOURCE = "liferayDataSource";
    public static final String SESSION_FACTORY = "liferaySessionFactory";
    public static final String TX_MANAGER = "liferayTransactionManager";
    public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.entity.cache.enabled.gov.va.med.mhv.liferay.model.LiferayService"),
            true);
    public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.finder.cache.enabled.gov.va.med.mhv.liferay.model.LiferayService"),
            true);
    public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.column.bitmask.enabled.gov.va.med.mhv.liferay.model.LiferayService"),
            true);
    public static long UUID_COLUMN_BITMASK = 1L;
    public static long SESSIONID_COLUMN_BITMASK = 2L;
    public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.util.service.ServiceProps.get(
                "lock.expiration.time.gov.va.med.mhv.liferay.model.LiferayService"));
    private static ClassLoader _classLoader = LiferayService.class.getClassLoader();
    private static Class<?>[] _escapedModelInterfaces = new Class[] {
            LiferayService.class
        };
    private String _uuid;
    private String _originalUuid;
    private long _sessionid;
    private long _columnBitmask;
    private LiferayService _escapedModel;

    public LiferayServiceModelImpl() {
    }

    /**
     * Converts the soap model instance into a normal model instance.
     *
     * @param soapModel the soap model instance to convert
     * @return the normal model instance
     */
    public static LiferayService toModel(LiferayServiceSoap soapModel) {
        if (soapModel == null) {
            return null;
        }

        LiferayService model = new LiferayServiceImpl();

        model.setUuid(soapModel.getUuid());
        model.setSessionid(soapModel.getSessionid());

        return model;
    }

    /**
     * Converts the soap model instances into normal model instances.
     *
     * @param soapModels the soap model instances to convert
     * @return the normal model instances
     */
    public static List<LiferayService> toModels(LiferayServiceSoap[] soapModels) {
        if (soapModels == null) {
            return null;
        }

        List<LiferayService> models = new ArrayList<LiferayService>(soapModels.length);

        for (LiferayServiceSoap soapModel : soapModels) {
            models.add(toModel(soapModel));
        }

        return models;
    }

    @Override
    public long getPrimaryKey() {
        return _sessionid;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setSessionid(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _sessionid;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Class<?> getModelClass() {
        return LiferayService.class;
    }

    @Override
    public String getModelClassName() {
        return LiferayService.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("uuid", getUuid());
        attributes.put("sessionid", getSessionid());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        String uuid = (String) attributes.get("uuid");

        if (uuid != null) {
            setUuid(uuid);
        }

        Long sessionid = (Long) attributes.get("sessionid");

        if (sessionid != null) {
            setSessionid(sessionid);
        }
    }

    @JSON
    @Override
    public String getUuid() {
        if (_uuid == null) {
            return StringPool.BLANK;
        } else {
            return _uuid;
        }
    }

    @Override
    public void setUuid(String uuid) {
        if (_originalUuid == null) {
            _originalUuid = _uuid;
        }

        _uuid = uuid;
    }

    public String getOriginalUuid() {
        return GetterUtil.getString(_originalUuid);
    }

    @JSON
    @Override
    public long getSessionid() {
        return _sessionid;
    }

    @Override
    public void setSessionid(long sessionid) {
        _sessionid = sessionid;
    }

    public long getColumnBitmask() {
        return _columnBitmask;
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge(0,
            LiferayService.class.getName(), getPrimaryKey());
    }

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        ExpandoBridge expandoBridge = getExpandoBridge();

        expandoBridge.setAttributes(serviceContext);
    }

    @Override
    public LiferayService toEscapedModel() {
        if (_escapedModel == null) {
            _escapedModel = (LiferayService) ProxyUtil.newProxyInstance(_classLoader,
                    _escapedModelInterfaces, new AutoEscapeBeanHandler(this));
        }

        return _escapedModel;
    }

    @Override
    public Object clone() {
        LiferayServiceImpl liferayServiceImpl = new LiferayServiceImpl();

        liferayServiceImpl.setUuid(getUuid());
        liferayServiceImpl.setSessionid(getSessionid());

        liferayServiceImpl.resetOriginalValues();

        return liferayServiceImpl;
    }

    @Override
    public int compareTo(LiferayService liferayService) {
        long primaryKey = liferayService.getPrimaryKey();

        if (getPrimaryKey() < primaryKey) {
            return -1;
        } else if (getPrimaryKey() > primaryKey) {
            return 1;
        } else {
            return 0;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof LiferayService)) {
            return false;
        }

        LiferayService liferayService = (LiferayService) obj;

        long primaryKey = liferayService.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public void resetOriginalValues() {
        LiferayServiceModelImpl liferayServiceModelImpl = this;

        liferayServiceModelImpl._originalUuid = liferayServiceModelImpl._uuid;

        liferayServiceModelImpl._columnBitmask = 0;
    }

    @Override
    public CacheModel<LiferayService> toCacheModel() {
        LiferayServiceCacheModel liferayServiceCacheModel = new LiferayServiceCacheModel();

        liferayServiceCacheModel.uuid = getUuid();

        String uuid = liferayServiceCacheModel.uuid;

        if ((uuid != null) && (uuid.length() == 0)) {
            liferayServiceCacheModel.uuid = null;
        }

        liferayServiceCacheModel.sessionid = getSessionid();

        return liferayServiceCacheModel;
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(5);

        sb.append("{uuid=");
        sb.append(getUuid());
        sb.append(", sessionid=");
        sb.append(getSessionid());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(10);

        sb.append("<model><model-name>");
        sb.append("gov.va.med.mhv.liferay.model.LiferayService");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>uuid</column-name><column-value><![CDATA[");
        sb.append(getUuid());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>sessionid</column-name><column-value><![CDATA[");
        sb.append(getSessionid());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
