package gov.va.med.mhv.liferay.model.impl;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;

import gov.va.med.mhv.liferay.model.LiferayService;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

/**
 * The cache model class for representing LiferayService in entity cache.
 *
 * @author Brian Wing Shun Chan
 * @see LiferayService
 * @generated
 */
public class LiferayServiceCacheModel implements CacheModel<LiferayService>,
    Externalizable {
    public String uuid;
    public long sessionid;

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(5);

        sb.append("{uuid=");
        sb.append(uuid);
        sb.append(", sessionid=");
        sb.append(sessionid);
        sb.append("}");

        return sb.toString();
    }

    @Override
    public LiferayService toEntityModel() {
        LiferayServiceImpl liferayServiceImpl = new LiferayServiceImpl();

        if (uuid == null) {
            liferayServiceImpl.setUuid(StringPool.BLANK);
        } else {
            liferayServiceImpl.setUuid(uuid);
        }

        liferayServiceImpl.setSessionid(sessionid);

        liferayServiceImpl.resetOriginalValues();

        return liferayServiceImpl;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        uuid = objectInput.readUTF();
        sessionid = objectInput.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput)
        throws IOException {
        if (uuid == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(uuid);
        }

        objectOutput.writeLong(sessionid);
    }
}
