package gov.va.med.mhv.liferay.service.persistence;

import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ReferenceRegistry;
import com.liferay.portal.service.ServiceContext;

import gov.va.med.mhv.liferay.model.LiferayService;

import java.util.List;

/**
 * The persistence utility for the liferay service service. This utility wraps {@link LiferayServicePersistenceImpl} and provides direct access to the database for CRUD operations. This utility should only be used by the service layer, as it must operate within a transaction. Never access this utility in a JSP, controller, model, or other front-end class.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see LiferayServicePersistence
 * @see LiferayServicePersistenceImpl
 * @generated
 */
public class LiferayServiceUtil {
    private static LiferayServicePersistence _persistence;

    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify this class directly. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache()
     */
    public static void clearCache() {
        getPersistence().clearCache();
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache(com.liferay.portal.model.BaseModel)
     */
    public static void clearCache(LiferayService liferayService) {
        getPersistence().clearCache(liferayService);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#countWithDynamicQuery(DynamicQuery)
     */
    public static long countWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().countWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery)
     */
    public static List<LiferayService> findWithDynamicQuery(
        DynamicQuery dynamicQuery) throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int)
     */
    public static List<LiferayService> findWithDynamicQuery(
        DynamicQuery dynamicQuery, int start, int end)
        throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery, start, end);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int, OrderByComparator)
     */
    public static List<LiferayService> findWithDynamicQuery(
        DynamicQuery dynamicQuery, int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        return getPersistence()
                   .findWithDynamicQuery(dynamicQuery, start, end,
            orderByComparator);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel)
     */
    public static LiferayService update(LiferayService liferayService)
        throws SystemException {
        return getPersistence().update(liferayService);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel, ServiceContext)
     */
    public static LiferayService update(LiferayService liferayService,
        ServiceContext serviceContext) throws SystemException {
        return getPersistence().update(liferayService, serviceContext);
    }

    /**
    * Returns all the liferay services where uuid = &#63;.
    *
    * @param uuid the uuid
    * @return the matching liferay services
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.med.mhv.liferay.model.LiferayService> findByUuid(
        java.lang.String uuid)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByUuid(uuid);
    }

    /**
    * Returns a range of all the liferay services where uuid = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.med.mhv.liferay.model.impl.LiferayServiceModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param uuid the uuid
    * @param start the lower bound of the range of liferay services
    * @param end the upper bound of the range of liferay services (not inclusive)
    * @return the range of matching liferay services
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.med.mhv.liferay.model.LiferayService> findByUuid(
        java.lang.String uuid, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByUuid(uuid, start, end);
    }

    /**
    * Returns an ordered range of all the liferay services where uuid = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.med.mhv.liferay.model.impl.LiferayServiceModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param uuid the uuid
    * @param start the lower bound of the range of liferay services
    * @param end the upper bound of the range of liferay services (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching liferay services
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.med.mhv.liferay.model.LiferayService> findByUuid(
        java.lang.String uuid, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByUuid(uuid, start, end, orderByComparator);
    }

    /**
    * Returns the first liferay service in the ordered set where uuid = &#63;.
    *
    * @param uuid the uuid
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching liferay service
    * @throws gov.va.med.mhv.liferay.NoSuchLiferayServiceException if a matching liferay service could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.med.mhv.liferay.model.LiferayService findByUuid_First(
        java.lang.String uuid,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.med.mhv.liferay.NoSuchLiferayServiceException {
        return getPersistence().findByUuid_First(uuid, orderByComparator);
    }

    /**
    * Returns the first liferay service in the ordered set where uuid = &#63;.
    *
    * @param uuid the uuid
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching liferay service, or <code>null</code> if a matching liferay service could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.med.mhv.liferay.model.LiferayService fetchByUuid_First(
        java.lang.String uuid,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByUuid_First(uuid, orderByComparator);
    }

    /**
    * Returns the last liferay service in the ordered set where uuid = &#63;.
    *
    * @param uuid the uuid
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching liferay service
    * @throws gov.va.med.mhv.liferay.NoSuchLiferayServiceException if a matching liferay service could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.med.mhv.liferay.model.LiferayService findByUuid_Last(
        java.lang.String uuid,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.med.mhv.liferay.NoSuchLiferayServiceException {
        return getPersistence().findByUuid_Last(uuid, orderByComparator);
    }

    /**
    * Returns the last liferay service in the ordered set where uuid = &#63;.
    *
    * @param uuid the uuid
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching liferay service, or <code>null</code> if a matching liferay service could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.med.mhv.liferay.model.LiferayService fetchByUuid_Last(
        java.lang.String uuid,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByUuid_Last(uuid, orderByComparator);
    }

    /**
    * Returns the liferay services before and after the current liferay service in the ordered set where uuid = &#63;.
    *
    * @param sessionid the primary key of the current liferay service
    * @param uuid the uuid
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next liferay service
    * @throws gov.va.med.mhv.liferay.NoSuchLiferayServiceException if a liferay service with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.med.mhv.liferay.model.LiferayService[] findByUuid_PrevAndNext(
        long sessionid, java.lang.String uuid,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.med.mhv.liferay.NoSuchLiferayServiceException {
        return getPersistence()
                   .findByUuid_PrevAndNext(sessionid, uuid, orderByComparator);
    }

    /**
    * Removes all the liferay services where uuid = &#63; from the database.
    *
    * @param uuid the uuid
    * @throws SystemException if a system exception occurred
    */
    public static void removeByUuid(java.lang.String uuid)
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeByUuid(uuid);
    }

    /**
    * Returns the number of liferay services where uuid = &#63;.
    *
    * @param uuid the uuid
    * @return the number of matching liferay services
    * @throws SystemException if a system exception occurred
    */
    public static int countByUuid(java.lang.String uuid)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countByUuid(uuid);
    }

    /**
    * Caches the liferay service in the entity cache if it is enabled.
    *
    * @param liferayService the liferay service
    */
    public static void cacheResult(
        gov.va.med.mhv.liferay.model.LiferayService liferayService) {
        getPersistence().cacheResult(liferayService);
    }

    /**
    * Caches the liferay services in the entity cache if it is enabled.
    *
    * @param liferayServices the liferay services
    */
    public static void cacheResult(
        java.util.List<gov.va.med.mhv.liferay.model.LiferayService> liferayServices) {
        getPersistence().cacheResult(liferayServices);
    }

    /**
    * Creates a new liferay service with the primary key. Does not add the liferay service to the database.
    *
    * @param sessionid the primary key for the new liferay service
    * @return the new liferay service
    */
    public static gov.va.med.mhv.liferay.model.LiferayService create(
        long sessionid) {
        return getPersistence().create(sessionid);
    }

    /**
    * Removes the liferay service with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param sessionid the primary key of the liferay service
    * @return the liferay service that was removed
    * @throws gov.va.med.mhv.liferay.NoSuchLiferayServiceException if a liferay service with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.med.mhv.liferay.model.LiferayService remove(
        long sessionid)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.med.mhv.liferay.NoSuchLiferayServiceException {
        return getPersistence().remove(sessionid);
    }

    public static gov.va.med.mhv.liferay.model.LiferayService updateImpl(
        gov.va.med.mhv.liferay.model.LiferayService liferayService)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().updateImpl(liferayService);
    }

    /**
    * Returns the liferay service with the primary key or throws a {@link gov.va.med.mhv.liferay.NoSuchLiferayServiceException} if it could not be found.
    *
    * @param sessionid the primary key of the liferay service
    * @return the liferay service
    * @throws gov.va.med.mhv.liferay.NoSuchLiferayServiceException if a liferay service with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.med.mhv.liferay.model.LiferayService findByPrimaryKey(
        long sessionid)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.med.mhv.liferay.NoSuchLiferayServiceException {
        return getPersistence().findByPrimaryKey(sessionid);
    }

    /**
    * Returns the liferay service with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param sessionid the primary key of the liferay service
    * @return the liferay service, or <code>null</code> if a liferay service with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.med.mhv.liferay.model.LiferayService fetchByPrimaryKey(
        long sessionid)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByPrimaryKey(sessionid);
    }

    /**
    * Returns all the liferay services.
    *
    * @return the liferay services
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.med.mhv.liferay.model.LiferayService> findAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll();
    }

    /**
    * Returns a range of all the liferay services.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.med.mhv.liferay.model.impl.LiferayServiceModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of liferay services
    * @param end the upper bound of the range of liferay services (not inclusive)
    * @return the range of liferay services
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.med.mhv.liferay.model.LiferayService> findAll(
        int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end);
    }

    /**
    * Returns an ordered range of all the liferay services.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.med.mhv.liferay.model.impl.LiferayServiceModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of liferay services
    * @param end the upper bound of the range of liferay services (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of liferay services
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.med.mhv.liferay.model.LiferayService> findAll(
        int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end, orderByComparator);
    }

    /**
    * Removes all the liferay services from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public static void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeAll();
    }

    /**
    * Returns the number of liferay services.
    *
    * @return the number of liferay services
    * @throws SystemException if a system exception occurred
    */
    public static int countAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countAll();
    }

    public static LiferayServicePersistence getPersistence() {
        if (_persistence == null) {
            _persistence = (LiferayServicePersistence) PortletBeanLocatorUtil.locate(gov.va.med.mhv.liferay.service.ClpSerializer.getServletContextName(),
                    LiferayServicePersistence.class.getName());

            ReferenceRegistry.registerReference(LiferayServiceUtil.class,
                "_persistence");
        }

        return _persistence;
    }

    /**
     * @deprecated As of 6.2.0
     */
    public void setPersistence(LiferayServicePersistence persistence) {
    }
}
